/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.server.extension;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.keycloak.subsystem.server.extension.KeycloakAdapterConfigService;
import org.keycloak.subsystem.server.extension.ServerUtil;

public final class KeycloakSubsystemRemoveHandler
extends ReloadRequiredRemoveStepHandler {
    static KeycloakSubsystemRemoveHandler INSTANCE = new KeycloakSubsystemRemoveHandler();

    private KeycloakSubsystemRemoveHandler() {
    }

    protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String deploymentName = ServerUtil.getDeploymentName(operation);
        KeycloakAdapterConfigService.INSTANCE.setWebContext(null);
        if (this.requiresRuntime(context)) {
            this.addStepToRemoveServerWar(context, deploymentName);
        }
        super.performRemove(context, operation, model);
    }

    private void addStepToRemoveServerWar(OperationContext context, String deploymentName) {
        PathAddress deploymentAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment", (String)deploymentName)});
        ModelNode op = Util.createOperation((String)"remove", (PathAddress)deploymentAddress);
        context.addStep(op, this.getRemoveHandler(context, deploymentAddress), OperationContext.Stage.MODEL);
    }

    private OperationStepHandler getRemoveHandler(OperationContext context, PathAddress address) {
        ImmutableManagementResourceRegistration rootResourceRegistration = context.getRootResourceRegistration();
        return rootResourceRegistration.getOperationHandler(address, "remove");
    }
}

