/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.role;

import java.util.Set;
import java.util.function.Function;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.evaluation.Evaluation;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.representations.idm.authorization.RolePolicyRepresentation;

public class RolePolicyProvider
implements PolicyProvider {
    private final Function<Policy, RolePolicyRepresentation> representationFunction;

    public RolePolicyProvider(Function<Policy, RolePolicyRepresentation> representationFunction) {
        this.representationFunction = representationFunction;
    }

    public void evaluate(Evaluation evaluation) {
        Policy policy = evaluation.getPolicy();
        Set roleIds = this.representationFunction.apply(policy).getRoles();
        AuthorizationProvider authorizationProvider = evaluation.getAuthorizationProvider();
        RealmModel realm = authorizationProvider.getKeycloakSession().getContext().getRealm();
        Identity identity = evaluation.getContext().getIdentity();
        for (RolePolicyRepresentation.RoleDefinition roleDefinition : roleIds) {
            RoleModel role = realm.getRoleById(roleDefinition.getId());
            if (role == null) continue;
            boolean hasRole = this.hasRole(identity, role, realm);
            if (!hasRole && roleDefinition.isRequired()) {
                evaluation.deny();
                return;
            }
            if (!hasRole) continue;
            evaluation.grant();
        }
    }

    private boolean hasRole(Identity identity, RoleModel role, RealmModel realm) {
        String roleName = role.getName();
        if (role.isClientRole()) {
            ClientModel clientModel = realm.getClientById(role.getContainerId());
            return identity.hasClientRole(clientModel.getClientId(), roleName);
        }
        return identity.hasRealmRole(roleName);
    }

    public void close() {
    }
}

