/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.entities;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.keycloak.authorization.jpa.entities.PolicyEntity;
import org.keycloak.authorization.jpa.entities.ResourceServerEntity;
import org.keycloak.authorization.jpa.entities.ScopeEntity;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.Scope;

@Entity
@Table(name="RESOURCE_SERVER_RESOURCE", uniqueConstraints={@UniqueConstraint(columnNames={"NAME", "RESOURCE_SERVER_ID", "OWNER"})})
public class ResourceEntity
implements Resource {
    @Id
    @Column(name="ID", length=36)
    @Access(value=AccessType.PROPERTY)
    private String id;
    @Column(name="NAME")
    private String name;
    @Column(name="URI")
    private String uri;
    @Column(name="TYPE")
    private String type;
    @Column(name="ICON_URI")
    private String iconUri;
    @Column(name="OWNER")
    private String owner;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="RESOURCE_SERVER_ID")
    private ResourceServerEntity resourceServer;
    @ManyToMany(fetch=FetchType.LAZY, cascade={})
    @JoinTable(name="RESOURCE_SCOPE", joinColumns={@JoinColumn(name="RESOURCE_ID")}, inverseJoinColumns={@JoinColumn(name="SCOPE_ID")})
    private List<ScopeEntity> scopes = new ArrayList<ScopeEntity>();
    @ManyToMany(fetch=FetchType.LAZY, cascade={})
    @JoinTable(name="RESOURCE_POLICY", joinColumns={@JoinColumn(name="RESOURCE_ID")}, inverseJoinColumns={@JoinColumn(name="POLICY_ID")})
    private List<PolicyEntity> policies = new ArrayList<PolicyEntity>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<ScopeEntity> getScopes() {
        return this.scopes;
    }

    public String getIconUri() {
        return this.iconUri;
    }

    public void setIconUri(String iconUri) {
        this.iconUri = iconUri;
    }

    public ResourceServerEntity getResourceServer() {
        return this.resourceServer;
    }

    public void setResourceServer(ResourceServerEntity resourceServer) {
        this.resourceServer = resourceServer;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public List<PolicyEntity> getPolicies() {
        return this.policies;
    }

    public void updateScopes(Set<Scope> toUpdate) {
        boolean hasScope;
        for (Scope scope : toUpdate) {
            hasScope = false;
            for (Scope scope2 : this.scopes) {
                if (!scope2.equals(scope)) continue;
                hasScope = true;
            }
            if (hasScope) continue;
            this.scopes.add((ScopeEntity)scope);
        }
        for (Scope scope : new HashSet<ScopeEntity>(this.scopes)) {
            hasScope = false;
            for (Scope scope3 : toUpdate) {
                if (!scope.equals(scope3)) continue;
                hasScope = true;
            }
            if (hasScope) continue;
            this.scopes.remove(scope);
        }
    }

    public void setPolicies(List<PolicyEntity> policies) {
        this.policies = policies;
    }
}

