/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.custom;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import liquibase.exception.CustomChangeException;
import liquibase.exception.DatabaseException;
import liquibase.statement.core.InsertStatement;
import liquibase.statement.core.UpdateStatement;
import liquibase.structure.core.Table;
import org.keycloak.Config;
import org.keycloak.connections.jpa.updater.liquibase.custom.CustomKeycloakTask;
import org.keycloak.migration.MigrationProvider;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;

public class JpaUpdate1_2_0_Beta1
extends CustomKeycloakTask {
    private String realmTableName;

    @Override
    protected String getTaskId() {
        return "Update 1.2.0.Beta1";
    }

    @Override
    protected void generateStatementsImpl() throws CustomChangeException {
        this.realmTableName = this.database.correctObjectName("REALM", Table.class);
        try {
            this.convertSocialToIdFedRealms();
            this.convertSocialToIdFedUsers();
            this.addAccessCodeLoginTimeout();
            this.addNewAdminRoles();
            this.addDefaultProtocolMappers();
        }
        catch (Exception e) {
            throw new CustomChangeException(this.getTaskId() + ": Exception when updating data from previous version", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void convertSocialToIdFedRealms() throws SQLException, DatabaseException {
        String identityProviderTableName = this.database.correctObjectName("IDENTITY_PROVIDER", Table.class);
        String idpConfigTableName = this.database.correctObjectName("IDENTITY_PROVIDER_CONFIG", Table.class);
        String realmSocialConfigTable = this.getTableName("REALM_SOCIAL_CONFIG");
        String realmTableName = this.getTableName("REALM");
        try (PreparedStatement statement = this.jdbcConnection.prepareStatement("select RSC.NAME, VALUE, REALM_ID, UPDATE_PROFILE_ON_SOC_LOGIN from " + realmSocialConfigTable + " RSC," + realmTableName + " REALM where RSC.REALM_ID = REALM.ID ORDER BY RSC.REALM_ID, RSC.NAME");
             ResultSet resultSet = statement.executeQuery();){
            boolean providerInProgress = false;
            String socialProviderId = null;
            String clientId = null;
            String realmId = null;
            boolean updateProfileOnSocialLogin = false;
            boolean first = true;
            while (resultSet.next()) {
                if (first) {
                    this.confirmationMessage.append("Migrating social to identity providers: ");
                    first = false;
                }
                if (!providerInProgress) {
                    String key = resultSet.getString("NAME");
                    int keyIndex = key.indexOf(".key");
                    if (keyIndex == -1) {
                        throw new IllegalStateException("Can't parse the provider from column: " + key);
                    }
                    socialProviderId = key.substring(0, keyIndex);
                    clientId = resultSet.getString("VALUE");
                    realmId = resultSet.getString("REALM_ID");
                    updateProfileOnSocialLogin = resultSet.getBoolean("UPDATE_PROFILE_ON_SOC_LOGIN");
                    providerInProgress = true;
                    continue;
                }
                String clientSecret = resultSet.getString("VALUE");
                String internalId = KeycloakModelUtils.generateId();
                InsertStatement idpInsert = new InsertStatement(null, null, identityProviderTableName).addColumnValue("INTERNAL_ID", (Object)internalId).addColumnValue("ENABLED", (Object)true).addColumnValue("PROVIDER_ALIAS", (Object)socialProviderId).addColumnValue("PROVIDER_ID", (Object)socialProviderId).addColumnValue("UPDATE_PROFILE_FIRST_LOGIN", (Object)updateProfileOnSocialLogin).addColumnValue("STORE_TOKEN", (Object)false).addColumnValue("AUTHENTICATE_BY_DEFAULT", (Object)false).addColumnValue("REALM_ID", (Object)realmId);
                InsertStatement clientIdInsert = new InsertStatement(null, null, idpConfigTableName).addColumnValue("IDENTITY_PROVIDER_ID", (Object)internalId).addColumnValue("NAME", (Object)"clientId").addColumnValue("VALUE", (Object)clientId);
                InsertStatement clientSecretInsert = new InsertStatement(null, null, idpConfigTableName).addColumnValue("IDENTITY_PROVIDER_ID", (Object)internalId).addColumnValue("NAME", (Object)"clientSecret").addColumnValue("VALUE", (Object)clientSecret);
                this.statements.add(idpInsert);
                this.statements.add(clientIdInsert);
                this.statements.add(clientSecretInsert);
                this.confirmationMessage.append(socialProviderId + " in realm " + realmId + ", ");
                providerInProgress = false;
            }
            if (!first) {
                this.confirmationMessage.append(". ");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void convertSocialToIdFedUsers() throws SQLException, DatabaseException {
        String federatedIdentityTableName = this.database.correctObjectName("FEDERATED_IDENTITY", Table.class);
        try (PreparedStatement statement = this.jdbcConnection.prepareStatement("select REALM_ID, USER_ID, SOCIAL_PROVIDER, SOCIAL_USER_ID, SOCIAL_USERNAME from " + this.getTableName("USER_SOCIAL_LINK"));
             ResultSet resultSet = statement.executeQuery();){
            int count = 0;
            while (resultSet.next()) {
                InsertStatement insert = new InsertStatement(null, null, federatedIdentityTableName).addColumnValue("REALM_ID", (Object)resultSet.getString("REALM_ID")).addColumnValue("USER_ID", (Object)resultSet.getString("USER_ID")).addColumnValue("IDENTITY_PROVIDER", (Object)resultSet.getString("SOCIAL_PROVIDER")).addColumnValue("FEDERATED_USER_ID", (Object)resultSet.getString("SOCIAL_USER_ID")).addColumnValue("FEDERATED_USERNAME", (Object)resultSet.getString("SOCIAL_USERNAME"));
                ++count;
                this.statements.add(insert);
            }
            this.confirmationMessage.append("Updating " + count + " social links to federated identities. ");
        }
    }

    protected void addAccessCodeLoginTimeout() {
        UpdateStatement statement = new UpdateStatement(null, null, this.realmTableName).addNewColumnValue("LOGIN_LIFESPAN", (Object)1800).setWhereClause("LOGIN_LIFESPAN IS NULL");
        this.statements.add(statement);
        this.confirmationMessage.append("Updated LOGIN_LIFESPAN of all realms to 1800 seconds. ");
    }

    private void addNewAdminRoles() throws SQLException, DatabaseException {
        this.addNewMasterAdminRoles();
        this.addNewRealmAdminRoles();
        this.confirmationMessage.append("Adding new admin roles. ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNewMasterAdminRoles() throws SQLException, DatabaseException {
        String adminRoleId = this.getAdminRoleId();
        String masterRealmId = Config.getAdminRealm();
        try (PreparedStatement statement = this.jdbcConnection.prepareStatement("select NAME from " + this.getTableName("REALM"));
             ResultSet resultSet = statement.executeQuery();){
            while (resultSet.next()) {
                String realmName = resultSet.getString("NAME");
                String masterAdminAppName = realmName + "-realm";
                PreparedStatement statement2 = this.jdbcConnection.prepareStatement("select ID from " + this.getTableName("CLIENT") + " where REALM_ID = ? AND NAME = ?");
                statement2.setString(1, masterRealmId);
                statement2.setString(2, masterAdminAppName);
                try (ResultSet resultSet2 = statement2.executeQuery();){
                    if (resultSet2.next()) {
                        String masterAdminAppId = resultSet2.getString("ID");
                        this.addAdminRole(AdminRoles.VIEW_IDENTITY_PROVIDERS, masterRealmId, masterAdminAppId, adminRoleId);
                        this.addAdminRole(AdminRoles.MANAGE_IDENTITY_PROVIDERS, masterRealmId, masterAdminAppId, adminRoleId);
                        continue;
                    }
                    throw new IllegalStateException("Couldn't find ID of '" + masterAdminAppName + "' application in 'master' realm. ");
                }
                finally {
                    statement2.close();
                }
            }
        }
    }

    private String getAdminRoleId() throws SQLException, DatabaseException {
        PreparedStatement statement = this.jdbcConnection.prepareStatement("select ID from " + this.getTableName("KEYCLOAK_ROLE") + " where NAME = ? AND REALM = ?");
        statement.setString(1, AdminRoles.ADMIN);
        statement.setString(2, Config.getAdminRealm());
        try (ResultSet resultSet = statement.executeQuery();){
            if (resultSet.next()) {
                String string = resultSet.getString("ID");
                return string;
            }
            throw new IllegalStateException("Couldn't find ID of 'admin' role in 'master' realm");
        }
        finally {
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNewRealmAdminRoles() throws SQLException, DatabaseException {
        statement.setString(1, AdminRoles.REALM_ADMIN);
        try (PreparedStatement statement = this.jdbcConnection.prepareStatement("select CLIENT.ID REALM_ADMIN_APP_ID, CLIENT.REALM_ID REALM_ID, KEYCLOAK_ROLE.ID ADMIN_ROLE_ID from " + this.getTableName("CLIENT") + " CLIENT," + this.getTableName("KEYCLOAK_ROLE") + " KEYCLOAK_ROLE where KEYCLOAK_ROLE.APPLICATION = CLIENT.ID AND CLIENT.NAME = 'realm-management' AND KEYCLOAK_ROLE.NAME = ?");
             ResultSet resultSet = statement.executeQuery();){
            while (resultSet.next()) {
                String realmAdminAppId = resultSet.getString("REALM_ADMIN_APP_ID");
                String realmId = resultSet.getString("REALM_ID");
                String adminRoleId = resultSet.getString("ADMIN_ROLE_ID");
                this.addAdminRole(AdminRoles.VIEW_IDENTITY_PROVIDERS, realmId, realmAdminAppId, adminRoleId);
                this.addAdminRole(AdminRoles.MANAGE_IDENTITY_PROVIDERS, realmId, realmAdminAppId, adminRoleId);
            }
        }
    }

    private void addAdminRole(String roleName, String realmId, String applicationId, String realmAdminAppRoleId) {
        String roleTableName = this.database.correctObjectName("KEYCLOAK_ROLE", Table.class);
        String compositeRoleTableName = this.database.correctObjectName("COMPOSITE_ROLE", Table.class);
        String newRoleId = KeycloakModelUtils.generateId();
        InsertStatement insertRole = new InsertStatement(null, null, roleTableName).addColumnValue("ID", (Object)newRoleId).addColumnValue("APP_REALM_CONSTRAINT", (Object)applicationId).addColumnValue("APPLICATION_ROLE", (Object)true).addColumnValue("NAME", (Object)roleName).addColumnValue("REALM_ID", (Object)realmId).addColumnValue("APPLICATION", (Object)applicationId);
        InsertStatement insertCompRole = new InsertStatement(null, null, compositeRoleTableName).addColumnValue("COMPOSITE", (Object)realmAdminAppRoleId).addColumnValue("CHILD_ROLE", (Object)newRoleId);
        this.statements.add(insertRole);
        this.statements.add(insertCompRole);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDefaultProtocolMappers() throws SQLException, DatabaseException {
        String protocolMapperTableName = this.database.correctObjectName("PROTOCOL_MAPPER", Table.class);
        String protocolMapperCfgTableName = this.database.correctObjectName("PROTOCOL_MAPPER_CONFIG", Table.class);
        try (PreparedStatement statement = this.jdbcConnection.prepareStatement("select ID, NAME, ALLOWED_CLAIMS_MASK from " + this.getTableName("CLIENT"));
             ResultSet resultSet = statement.executeQuery();){
            boolean first = true;
            while (resultSet.next()) {
                Object acmObj;
                if (first) {
                    this.confirmationMessage.append("Migrating claimsMask to protocol mappers for clients: ");
                    first = false;
                }
                long mask = (acmObj = resultSet.getObject("ALLOWED_CLAIMS_MASK")) != null ? ((Number)acmObj).longValue() : 1023L;
                MigrationProvider migrationProvider = (MigrationProvider)this.kcSession.getProvider(MigrationProvider.class);
                List protocolMappers = migrationProvider.getMappersForClaimMask(Long.valueOf(mask));
                for (ProtocolMapperRepresentation protocolMapper : protocolMappers) {
                    String mapperId = KeycloakModelUtils.generateId();
                    InsertStatement insert = new InsertStatement(null, null, protocolMapperTableName).addColumnValue("ID", (Object)mapperId).addColumnValue("PROTOCOL", (Object)protocolMapper.getProtocol()).addColumnValue("NAME", (Object)protocolMapper.getName()).addColumnValue("CONSENT_REQUIRED", (Object)protocolMapper.isConsentRequired()).addColumnValue("CONSENT_TEXT", (Object)protocolMapper.getConsentText()).addColumnValue("PROTOCOL_MAPPER_NAME", (Object)protocolMapper.getProtocolMapper()).addColumnValue("CLIENT_ID", (Object)resultSet.getString("ID"));
                    this.statements.add(insert);
                    for (Map.Entry cfgEntry : protocolMapper.getConfig().entrySet()) {
                        InsertStatement cfgInsert = new InsertStatement(null, null, protocolMapperCfgTableName).addColumnValue("PROTOCOL_MAPPER_ID", (Object)mapperId).addColumnValue("NAME", cfgEntry.getKey()).addColumnValue("VALUE", cfgEntry.getValue());
                        this.statements.add(cfgInsert);
                    }
                }
                this.confirmationMessage.append(resultSet.getString("NAME") + ", ");
            }
            if (!first) {
                this.confirmationMessage.append(". ");
            }
        }
    }
}

