/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.events.jpa;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.events.admin.AdminEventQuery;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.events.jpa.AdminEventEntity;
import org.keycloak.events.jpa.JpaEventStoreProvider;

public class JpaAdminEventQuery
implements AdminEventQuery {
    private final EntityManager em;
    private final CriteriaBuilder cb;
    private final CriteriaQuery<AdminEventEntity> cq;
    private final Root<AdminEventEntity> root;
    private final ArrayList<Predicate> predicates;
    private Integer firstResult;
    private Integer maxResults;

    public JpaAdminEventQuery(EntityManager em) {
        this.em = em;
        this.cb = em.getCriteriaBuilder();
        this.cq = this.cb.createQuery(AdminEventEntity.class);
        this.root = this.cq.from(AdminEventEntity.class);
        this.predicates = new ArrayList();
    }

    public AdminEventQuery realm(String realmId) {
        this.predicates.add(this.cb.equal((Expression)this.root.get("realmId"), (Object)realmId));
        return this;
    }

    public AdminEventQuery operation(OperationType ... operations) {
        LinkedList<String> operationStrings = new LinkedList<String>();
        for (OperationType e : operations) {
            operationStrings.add(e.toString());
        }
        this.predicates.add(this.root.get("operationType").in(operationStrings));
        return this;
    }

    public AdminEventQuery resourceType(ResourceType ... resourceTypes) {
        LinkedList<String> resourceTypeStrings = new LinkedList<String>();
        for (ResourceType e : resourceTypes) {
            resourceTypeStrings.add(e.toString());
        }
        this.predicates.add(this.root.get("resourceType").in(resourceTypeStrings));
        return this;
    }

    public AdminEventQuery authRealm(String authRealmId) {
        this.predicates.add(this.cb.equal((Expression)this.root.get("authRealmId"), (Object)authRealmId));
        return this;
    }

    public AdminEventQuery authClient(String authClientId) {
        this.predicates.add(this.cb.equal((Expression)this.root.get("authClientId"), (Object)authClientId));
        return this;
    }

    public AdminEventQuery authUser(String authUserId) {
        this.predicates.add(this.cb.equal((Expression)this.root.get("authUserId"), (Object)authUserId));
        return this;
    }

    public AdminEventQuery authIpAddress(String ipAddress) {
        this.predicates.add(this.cb.equal((Expression)this.root.get("authIpAddress"), (Object)ipAddress));
        return this;
    }

    public AdminEventQuery resourcePath(String resourcePath) {
        Path rPath = this.root.get("resourcePath");
        this.predicates.add(this.cb.like((Expression)rPath, resourcePath.replace('*', '%')));
        return this;
    }

    public AdminEventQuery fromTime(Date fromTime) {
        this.predicates.add(this.cb.greaterThanOrEqualTo((Expression)this.root.get("time"), (Comparable)Long.valueOf(fromTime.getTime())));
        return this;
    }

    public AdminEventQuery toTime(Date toTime) {
        this.predicates.add(this.cb.lessThanOrEqualTo((Expression)this.root.get("time"), (Comparable)Long.valueOf(toTime.getTime())));
        return this;
    }

    public AdminEventQuery firstResult(int firstResult) {
        this.firstResult = firstResult;
        return this;
    }

    public AdminEventQuery maxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public List<AdminEvent> getResultList() {
        if (!this.predicates.isEmpty()) {
            this.cq.where((Expression)this.cb.and(this.predicates.toArray(new Predicate[this.predicates.size()])));
        }
        this.cq.orderBy(new Order[]{this.cb.desc((Expression)this.root.get("time"))});
        TypedQuery query = this.em.createQuery(this.cq);
        if (this.firstResult != null) {
            query.setFirstResult(this.firstResult.intValue());
        }
        if (this.maxResults != null) {
            query.setMaxResults(this.maxResults.intValue());
        }
        LinkedList<AdminEvent> events = new LinkedList<AdminEvent>();
        for (AdminEventEntity e : query.getResultList()) {
            events.add(JpaEventStoreProvider.convertAdminEvent(e));
        }
        return events;
    }
}

