/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.js;

import java.util.function.BiFunction;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.evaluation.Evaluation;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.scripting.EvaluatableScriptAdapter;

class JSPolicyProvider
implements PolicyProvider {
    private final BiFunction<AuthorizationProvider, Policy, EvaluatableScriptAdapter> evaluatableScript;

    JSPolicyProvider(BiFunction<AuthorizationProvider, Policy, EvaluatableScriptAdapter> evaluatableScript) {
        this.evaluatableScript = evaluatableScript;
    }

    public void evaluate(Evaluation evaluation) {
        Policy policy = evaluation.getPolicy();
        AuthorizationProvider authorization = evaluation.getAuthorizationProvider();
        EvaluatableScriptAdapter adapter = this.evaluatableScript.apply(authorization, policy);
        try {
            adapter.eval(bindings -> {
                bindings.put("script", (Object)adapter.getScriptModel());
                bindings.put("$evaluation", (Object)evaluation);
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Error evaluating JS Policy [" + policy.getName() + "].", e);
        }
    }

    public void close() {
    }
}

