/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.util.Collections;
import java.util.List;
import javax.crypto.SecretKey;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.component.ComponentModel;
import org.keycloak.keys.HmacKeyMetadata;
import org.keycloak.keys.HmacKeyProvider;
import org.keycloak.keys.KeyMetadata;

public class GeneratedHmacKeyProvider
implements HmacKeyProvider {
    private final boolean enabled;
    private final boolean active;
    private final ComponentModel model;
    private final String kid;
    private final SecretKey secretKey;

    public GeneratedHmacKeyProvider(ComponentModel model) {
        this.enabled = model.get("enabled", true);
        this.active = model.get("active", true);
        this.kid = model.get("kid");
        this.model = model;
        if (model.hasNote(SecretKey.class.getName())) {
            this.secretKey = (SecretKey)model.getNote(SecretKey.class.getName());
        } else {
            this.secretKey = KeyUtils.loadSecretKey((byte[])Base64Url.decode((String)model.get("secret")));
            model.setNote(SecretKey.class.getName(), (Object)this.secretKey);
        }
    }

    public SecretKey getSecretKey() {
        return this.isActive() ? this.secretKey : null;
    }

    public SecretKey getSecretKey(String kid) {
        return this.isEnabled() && kid.equals(this.kid) ? this.secretKey : null;
    }

    public String getKid() {
        return this.isActive() ? this.kid : null;
    }

    public List<HmacKeyMetadata> getKeyMetadata() {
        if (this.kid != null && this.secretKey != null) {
            HmacKeyMetadata k = new HmacKeyMetadata();
            k.setProviderId(this.model.getId());
            k.setProviderPriority(this.model.get("priority", 0L));
            k.setKid(this.kid);
            if (this.isActive()) {
                k.setStatus(KeyMetadata.Status.ACTIVE);
            } else if (this.isEnabled()) {
                k.setStatus(KeyMetadata.Status.PASSIVE);
            } else {
                k.setStatus(KeyMetadata.Status.DISABLED);
            }
            return Collections.singletonList(k);
        }
        return Collections.emptyList();
    }

    public void close() {
    }

    private boolean isEnabled() {
        return this.secretKey != null && this.enabled;
    }

    private boolean isActive() {
        return this.isEnabled() && this.active;
    }
}

