/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.GET;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.AuthorizationEndpointBase;
import org.keycloak.protocol.oidc.OIDCLoginProtocol;
import org.keycloak.protocol.oidc.endpoints.request.AuthorizationEndpointRequest;
import org.keycloak.protocol.oidc.endpoints.request.AuthorizationEndpointRequestParserProcessor;
import org.keycloak.protocol.oidc.utils.OIDCRedirectUriBuilder;
import org.keycloak.protocol.oidc.utils.OIDCResponseMode;
import org.keycloak.protocol.oidc.utils.OIDCResponseType;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.services.ErrorPageException;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.util.CacheControlUtil;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.util.TokenUtil;

public class AuthorizationEndpoint
extends AuthorizationEndpointBase {
    private static final Logger logger = Logger.getLogger(AuthorizationEndpoint.class);
    public static final String CODE_AUTH_TYPE = "code";
    public static final String LOGIN_SESSION_NOTE_ADDITIONAL_REQ_PARAMS_PREFIX = "client_request_param_";
    private static final Pattern VALID_CODE_CHALLENGE_PATTERN = Pattern.compile("^[0-9a-zA-Z\\-\\.~_]+$");
    private ClientModel client;
    private AuthenticationSessionModel authenticationSession;
    private Action action;
    private OIDCResponseType parsedResponseType;
    private OIDCResponseMode parsedResponseMode;
    private AuthorizationEndpointRequest request;
    private String redirectUri;

    public AuthorizationEndpoint(RealmModel realm, EventBuilder event) {
        super(realm, event);
        event.event(EventType.LOGIN);
    }

    @GET
    public Response build() {
        MultivaluedMap params = this.uriInfo.getQueryParameters();
        String requestUri = this.uriInfo.getRequestUri().toString();
        String clientId = (String)params.getFirst((Object)"client_id");
        this.checkSsl();
        this.checkRealm();
        this.checkClient(clientId);
        this.request = AuthorizationEndpointRequestParserProcessor.parseRequest(this.event, this.session, this.client, (MultivaluedMap<String, String>)params);
        this.checkRedirectUri();
        Response errorResponse = this.checkResponseType();
        if (errorResponse != null) {
            return errorResponse;
        }
        if (!TokenUtil.isOIDCRequest((String)this.request.getScope())) {
            ServicesLogger.LOGGER.oidcScopeMissing();
        }
        if ((errorResponse = this.checkOIDCParams()) != null) {
            return errorResponse;
        }
        errorResponse = this.checkPKCEParams();
        if (errorResponse != null) {
            return errorResponse;
        }
        AuthorizationEndpointBase.AuthorizationEndpointChecks checks = this.getOrCreateAuthenticationSession(this.client, this.request.getState());
        if (checks.response != null) {
            return checks.response;
        }
        this.authenticationSession = checks.authSession;
        this.updateAuthenticationSession();
        CacheControlUtil.noBackButtonCacheControlHeader();
        switch (this.action) {
            case REGISTER: {
                return this.buildRegister();
            }
            case FORGOT_CREDENTIALS: {
                return this.buildForgotCredential();
            }
            case CODE: {
                return this.buildAuthorizationCodeAuthorizationResponse();
            }
        }
        throw new RuntimeException("Unknown action " + (Object)((Object)this.action));
    }

    public AuthorizationEndpoint register() {
        this.event.event(EventType.REGISTER);
        this.action = Action.REGISTER;
        if (!this.realm.isRegistrationAllowed()) {
            throw new ErrorPageException(this.session, "registrationNotAllowedMessage", new Object[0]);
        }
        return this;
    }

    public AuthorizationEndpoint forgotCredentials() {
        this.event.event(EventType.RESET_PASSWORD);
        this.action = Action.FORGOT_CREDENTIALS;
        if (!this.realm.isResetPasswordAllowed()) {
            throw new ErrorPageException(this.session, "resetCredentialNotAllowedMessage", new Object[0]);
        }
        return this;
    }

    private void checkClient(String clientId) {
        if (clientId == null) {
            this.event.error("invalid_request");
            throw new ErrorPageException(this.session, "missingParameterMessage", "client_id");
        }
        this.event.client(clientId);
        this.client = this.realm.getClientByClientId(clientId);
        if (this.client == null) {
            this.event.error("client_not_found");
            throw new ErrorPageException(this.session, "clientNotFoundMessage", new Object[0]);
        }
        if (!this.client.isEnabled()) {
            this.event.error("client_disabled");
            throw new ErrorPageException(this.session, "clientDisabledMessage", new Object[0]);
        }
        if (this.client.isBearerOnly()) {
            this.event.error("not_allowed");
            throw new ErrorPageException(this.session, "bearerOnlyMessage", new Object[0]);
        }
        this.session.getContext().setClient(this.client);
    }

    private Response checkResponseType() {
        String responseType = this.request.getResponseType();
        if (responseType == null) {
            ServicesLogger.LOGGER.missingParameter("response_type");
            this.event.error("invalid_request");
            return this.redirectErrorToClient(OIDCResponseMode.QUERY, "invalid_request", "Missing parameter: response_type");
        }
        this.event.detail("response_type", responseType);
        try {
            this.parsedResponseType = OIDCResponseType.parse(responseType);
            if (this.action == null) {
                this.action = Action.CODE;
            }
        }
        catch (IllegalArgumentException iae) {
            logger.error((Object)iae.getMessage());
            this.event.error("invalid_request");
            return this.redirectErrorToClient(OIDCResponseMode.QUERY, "unsupported_response_type", null);
        }
        OIDCResponseMode parsedResponseMode = null;
        try {
            parsedResponseMode = OIDCResponseMode.parse(this.request.getResponseMode(), this.parsedResponseType);
        }
        catch (IllegalArgumentException iae) {
            ServicesLogger.LOGGER.invalidParameter("response_mode");
            this.event.error("invalid_request");
            return this.redirectErrorToClient(OIDCResponseMode.QUERY, "invalid_request", "Invalid parameter: response_mode");
        }
        this.event.detail("response_mode", parsedResponseMode.toString().toLowerCase());
        if (this.parsedResponseType.isImplicitOrHybridFlow() && parsedResponseMode == OIDCResponseMode.QUERY) {
            ServicesLogger.LOGGER.responseModeQueryNotAllowed();
            this.event.error("invalid_request");
            return this.redirectErrorToClient(OIDCResponseMode.QUERY, "invalid_request", "Response_mode 'query' not allowed for implicit or hybrid flow");
        }
        if ((this.parsedResponseType.hasResponseType(CODE_AUTH_TYPE) || this.parsedResponseType.hasResponseType("none")) && !this.client.isStandardFlowEnabled()) {
            ServicesLogger.LOGGER.flowNotAllowed("Standard");
            this.event.error("not_allowed");
            return this.redirectErrorToClient(parsedResponseMode, "unsupported_response_type", "Client is not allowed to initiate browser login with given response_type. Standard flow is disabled for the client.");
        }
        if (this.parsedResponseType.isImplicitOrHybridFlow() && !this.client.isImplicitFlowEnabled()) {
            ServicesLogger.LOGGER.flowNotAllowed("Implicit");
            this.event.error("not_allowed");
            return this.redirectErrorToClient(parsedResponseMode, "unsupported_response_type", "Client is not allowed to initiate browser login with given response_type. Implicit flow is disabled for the client.");
        }
        this.parsedResponseMode = parsedResponseMode;
        return null;
    }

    private Response checkOIDCParams() {
        boolean isOIDCRequest = TokenUtil.isOIDCRequest((String)this.request.getScope());
        if (!isOIDCRequest && this.parsedResponseType.toString().equals("token")) {
            return null;
        }
        if (this.parsedResponseType.isImplicitOrHybridFlow() && this.request.getNonce() == null) {
            ServicesLogger.LOGGER.missingParameter("nonce");
            this.event.error("invalid_request");
            return this.redirectErrorToClient(this.parsedResponseMode, "invalid_request", "Missing parameter: nonce");
        }
        return null;
    }

    private Response checkPKCEParams() {
        String codeChallenge = this.request.getCodeChallenge();
        String codeChallengeMethod = this.request.getCodeChallengeMethod();
        if (this.parsedResponseType.isImplicitFlow()) {
            return null;
        }
        if (codeChallenge == null && codeChallengeMethod != null) {
            logger.info((Object)"PKCE supporting Client without code challenge");
            this.event.error("invalid_request");
            return this.redirectErrorToClient(this.parsedResponseMode, "invalid_request", "Missing parameter: code_challenge");
        }
        if (codeChallenge == null) {
            logger.debug((Object)"PKCE non-supporting Client");
            return null;
        }
        if (codeChallengeMethod != null) {
            if (!codeChallengeMethod.equals("S256") && !codeChallengeMethod.equals("plain")) {
                logger.infof("PKCE supporting Client with invalid code challenge method not specified in PKCE, codeChallengeMethod = %s", (Object)codeChallengeMethod);
                this.event.error("invalid_request");
                return this.redirectErrorToClient(this.parsedResponseMode, "invalid_request", "Invalid parameter: code_challenge_method");
            }
        } else {
            codeChallengeMethod = "plain";
        }
        if (!this.isValidPkceCodeChallenge(codeChallenge)) {
            logger.infof("PKCE supporting Client with invalid code challenge specified in PKCE, codeChallenge = %s", (Object)codeChallenge);
            this.event.error("invalid_request");
            return this.redirectErrorToClient(this.parsedResponseMode, "invalid_request", "Invalid parameter: code_challenge");
        }
        return null;
    }

    private boolean isValidPkceCodeChallenge(String codeChallenge) {
        if (codeChallenge.length() < 43) {
            logger.debugf("PKCE codeChallenge length under lower limit , codeChallenge = %s", (Object)codeChallenge);
            return false;
        }
        if (codeChallenge.length() > 128) {
            logger.debugf("PKCE codeChallenge length over upper limit , codeChallenge = %s", (Object)codeChallenge);
            return false;
        }
        Matcher m = VALID_CODE_CHALLENGE_PATTERN.matcher(codeChallenge);
        return m.matches();
    }

    private Response redirectErrorToClient(OIDCResponseMode responseMode, String error, String errorDescription) {
        OIDCRedirectUriBuilder errorResponseBuilder = OIDCRedirectUriBuilder.fromUri(this.redirectUri, responseMode).addParam("error", error);
        if (errorDescription != null) {
            errorResponseBuilder.addParam("error_description", errorDescription);
        }
        if (this.request.getState() != null) {
            errorResponseBuilder.addParam("state", this.request.getState());
        }
        return errorResponseBuilder.build();
    }

    private void checkRedirectUri() {
        String redirectUriParam = this.request.getRedirectUriParam();
        boolean isOIDCRequest = TokenUtil.isOIDCRequest((String)this.request.getScope());
        this.event.detail("redirect_uri", redirectUriParam);
        this.redirectUri = RedirectUtils.verifyRedirectUri(this.uriInfo, redirectUriParam, this.realm, this.client, isOIDCRequest);
        if (this.redirectUri == null) {
            this.event.error("invalid_redirect_uri");
            throw new ErrorPageException(this.session, "invalidParameterMessage", "redirect_uri");
        }
    }

    @Override
    protected boolean isNewRequest(AuthenticationSessionModel authSession, ClientModel clientFromRequest, String stateFromRequest) {
        boolean stateChanged;
        if (stateFromRequest == null) {
            return true;
        }
        if (!clientFromRequest.equals(authSession.getClient())) {
            return true;
        }
        String stateFromSession = authSession.getClientNote("state");
        boolean bl = stateChanged = !stateFromRequest.equals(stateFromSession);
        if (stateChanged) {
            return true;
        }
        return this.isOIDCAuthenticationRelatedParamsChanged(authSession);
    }

    @Override
    protected boolean shouldRestartAuthSession(AuthenticationSessionModel authSession) {
        return super.shouldRestartAuthSession(authSession) || this.isOIDCAuthenticationRelatedParamsChanged(authSession);
    }

    private boolean isOIDCAuthenticationRelatedParamsChanged(AuthenticationSessionModel authSession) {
        if (this.isRequestParamChanged(authSession, "login_hint", this.request.getLoginHint())) {
            return true;
        }
        if (this.isRequestParamChanged(authSession, "prompt", this.request.getPrompt())) {
            return true;
        }
        if (this.isRequestParamChanged(authSession, "kc_idp_hint", this.request.getIdpHint())) {
            return true;
        }
        String maxAgeValue = authSession.getClientNote("max_age");
        if (maxAgeValue == null && this.request.getMaxAge() == null) {
            return false;
        }
        return maxAgeValue == null || Integer.parseInt(maxAgeValue) != this.request.getMaxAge();
    }

    private boolean isRequestParamChanged(AuthenticationSessionModel authSession, String noteName, String requestParamValue) {
        String authSessionNoteValue = authSession.getClientNote(noteName);
        return !Objects.equals(authSessionNoteValue, requestParamValue);
    }

    private void updateAuthenticationSession() {
        this.authenticationSession.setProtocol("openid-connect");
        this.authenticationSession.setRedirectUri(this.redirectUri);
        this.authenticationSession.setAction(CommonClientSessionModel.Action.AUTHENTICATE.name());
        this.authenticationSession.setClientNote("response_type", this.request.getResponseType());
        this.authenticationSession.setClientNote("redirect_uri", this.request.getRedirectUriParam());
        this.authenticationSession.setClientNote("iss", Urls.realmIssuer(this.uriInfo.getBaseUri(), this.realm.getName()));
        if (this.request.getState() != null) {
            this.authenticationSession.setClientNote("state", this.request.getState());
        }
        if (this.request.getNonce() != null) {
            this.authenticationSession.setClientNote("nonce", this.request.getNonce());
        }
        if (this.request.getMaxAge() != null) {
            this.authenticationSession.setClientNote("max_age", String.valueOf(this.request.getMaxAge()));
        }
        if (this.request.getScope() != null) {
            this.authenticationSession.setClientNote("scope", this.request.getScope());
        }
        if (this.request.getLoginHint() != null) {
            this.authenticationSession.setClientNote("login_hint", this.request.getLoginHint());
        }
        if (this.request.getPrompt() != null) {
            this.authenticationSession.setClientNote("prompt", this.request.getPrompt());
        }
        if (this.request.getIdpHint() != null) {
            this.authenticationSession.setClientNote("kc_idp_hint", this.request.getIdpHint());
        }
        if (this.request.getResponseMode() != null) {
            this.authenticationSession.setClientNote("response_mode", this.request.getResponseMode());
        }
        if (this.request.getCodeChallenge() != null) {
            this.authenticationSession.setClientNote("code_challenge", this.request.getCodeChallenge());
        }
        if (this.request.getCodeChallengeMethod() != null) {
            this.authenticationSession.setClientNote("code_challenge_method", this.request.getCodeChallengeMethod());
        } else {
            this.authenticationSession.setClientNote("code_challenge_method", "plain");
        }
        if (this.request.getAdditionalReqParams() != null) {
            for (String paramName : this.request.getAdditionalReqParams().keySet()) {
                this.authenticationSession.setClientNote(LOGIN_SESSION_NOTE_ADDITIONAL_REQ_PARAMS_PREFIX + paramName, this.request.getAdditionalReqParams().get(paramName));
            }
        }
    }

    private Response buildAuthorizationCodeAuthorizationResponse() {
        this.event.event(EventType.LOGIN);
        this.authenticationSession.setAuthNote("auth_type", CODE_AUTH_TYPE);
        return this.handleBrowserAuthenticationRequest(this.authenticationSession, new OIDCLoginProtocol(this.session, this.realm, this.uriInfo, this.headers, this.event), TokenUtil.hasPrompt((String)this.request.getPrompt(), (String)"none"), false);
    }

    private Response buildRegister() {
        AuthenticationManager.expireIdentityCookie(this.realm, this.uriInfo, this.clientConnection);
        AuthenticationFlowModel flow = this.realm.getRegistrationFlow();
        String flowId = flow.getId();
        AuthenticationProcessor processor = this.createProcessor(this.authenticationSession, flowId, "registration");
        this.authenticationSession.setClientNote("APP_INITIATED_FLOW", "registration");
        return processor.authenticate();
    }

    private Response buildForgotCredential() {
        AuthenticationManager.expireIdentityCookie(this.realm, this.uriInfo, this.clientConnection);
        AuthenticationFlowModel flow = this.realm.getResetCredentialsFlow();
        String flowId = flow.getId();
        AuthenticationProcessor processor = this.createProcessor(this.authenticationSession, flowId, "reset-credentials");
        this.authenticationSession.setClientNote("APP_INITIATED_FLOW", "reset-credentials");
        return processor.authenticate();
    }

    private static enum Action {
        REGISTER,
        CODE,
        FORGOT_CREDENTIALS;

    }
}

