/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.authorization.model.CachedModel;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.models.cache.infinispan.authorization.StoreFactoryCacheSession;
import org.keycloak.models.cache.infinispan.authorization.entities.CachedResource;

public class ResourceAdapter
implements Resource,
CachedModel<Resource> {
    protected CachedResource cached;
    protected StoreFactoryCacheSession cacheSession;
    protected Resource updated;
    protected boolean invalidated;
    protected List<Scope> scopes;

    public ResourceAdapter(CachedResource cached, StoreFactoryCacheSession cacheSession) {
        this.cached = cached;
        this.cacheSession = cacheSession;
    }

    public Resource getDelegateForUpdate() {
        if (this.updated == null) {
            this.cacheSession.registerResourceInvalidation(this.cached.getId(), this.cached.getName(), this.cached.getType(), this.cached.getUri(), this.cached.getScopesIds(), this.cached.getResourceServerId(), this.cached.getOwner());
            this.updated = this.cacheSession.getResourceStoreDelegate().findById(this.cached.getId(), this.cached.getResourceServerId());
            if (this.updated == null) {
                throw new IllegalStateException("Not found in database");
            }
        }
        return this.updated;
    }

    protected void invalidateFlag() {
        this.invalidated = true;
    }

    public void invalidate() {
        this.invalidated = true;
        this.getDelegateForUpdate();
    }

    public long getCacheTimestamp() {
        return this.cached.getCacheTimestamp();
    }

    protected boolean isUpdated() {
        if (this.updated != null) {
            return true;
        }
        if (!this.invalidated) {
            return false;
        }
        this.updated = this.cacheSession.getResourceStoreDelegate().findById(this.cached.getId(), this.cached.getResourceServerId());
        if (this.updated == null) {
            throw new IllegalStateException("Not found in database");
        }
        return true;
    }

    public String getId() {
        if (this.isUpdated()) {
            return this.updated.getId();
        }
        return this.cached.getId();
    }

    public String getName() {
        if (this.isUpdated()) {
            return this.updated.getName();
        }
        return this.cached.getName();
    }

    public void setName(String name) {
        this.getDelegateForUpdate();
        this.cacheSession.registerResourceInvalidation(this.cached.getId(), name, this.cached.getType(), this.cached.getUri(), this.cached.getScopesIds(), this.cached.getResourceServerId(), this.cached.getOwner());
        this.updated.setName(name);
    }

    public String getIconUri() {
        if (this.isUpdated()) {
            return this.updated.getIconUri();
        }
        return this.cached.getIconUri();
    }

    public void setIconUri(String iconUri) {
        this.getDelegateForUpdate();
        this.updated.setIconUri(iconUri);
    }

    public ResourceServer getResourceServer() {
        return this.cacheSession.getResourceServerStore().findById(this.cached.getResourceServerId());
    }

    public String getUri() {
        if (this.isUpdated()) {
            return this.updated.getUri();
        }
        return this.cached.getUri();
    }

    public void setUri(String uri) {
        this.getDelegateForUpdate();
        this.cacheSession.registerResourceInvalidation(this.cached.getId(), this.cached.getName(), this.cached.getType(), uri, this.cached.getScopesIds(), this.cached.getResourceServerId(), this.cached.getOwner());
        this.updated.setUri(uri);
    }

    public String getType() {
        if (this.isUpdated()) {
            return this.updated.getType();
        }
        return this.cached.getType();
    }

    public void setType(String type) {
        this.getDelegateForUpdate();
        this.cacheSession.registerResourceInvalidation(this.cached.getId(), this.cached.getName(), type, this.cached.getUri(), this.cached.getScopesIds(), this.cached.getResourceServerId(), this.cached.getOwner());
        this.updated.setType(type);
    }

    public List<Scope> getScopes() {
        if (this.isUpdated()) {
            return this.updated.getScopes();
        }
        if (this.scopes != null) {
            return this.scopes;
        }
        this.scopes = new LinkedList<Scope>();
        for (String scopeId : this.cached.getScopesIds()) {
            this.scopes.add(this.cacheSession.getScopeStore().findById(scopeId, this.cached.getResourceServerId()));
        }
        this.scopes = Collections.unmodifiableList(this.scopes);
        return this.scopes;
    }

    public String getOwner() {
        if (this.isUpdated()) {
            return this.updated.getOwner();
        }
        return this.cached.getOwner();
    }

    public void updateScopes(Set<Scope> scopes) {
        this.getDelegateForUpdate();
        this.cacheSession.registerResourceInvalidation(this.cached.getId(), this.cached.getName(), this.cached.getType(), this.cached.getUri(), scopes.stream().map(scope1 -> scope1.getId()).collect(Collectors.toSet()), this.cached.getResourceServerId(), this.cached.getOwner());
        this.updated.updateScopes(scopes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Resource)) {
            return false;
        }
        Resource that = (Resource)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

