/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.remoting.transport.Address;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.ActionTokenStoreProvider;
import org.keycloak.models.ActionTokenStoreProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.cache.infinispan.events.RemoveActionTokensSpecificEvent;
import org.keycloak.models.sessions.infinispan.InfinispanActionTokenStoreProvider;
import org.keycloak.models.sessions.infinispan.entities.ActionTokenReducedKey;
import org.keycloak.models.sessions.infinispan.entities.ActionTokenValueEntity;

public class InfinispanActionTokenStoreProviderFactory
implements ActionTokenStoreProviderFactory {
    private static final Logger LOG = Logger.getLogger(InfinispanActionTokenStoreProviderFactory.class);
    private volatile Cache<ActionTokenReducedKey, ActionTokenValueEntity> actionTokenCache;
    public static final String ACTION_TOKEN_EVENTS = "ACTION_TOKEN_EVENTS";
    private static final int DEFAULT_CACHE_EXPIRATION = 0;
    private Config.Scope config;

    public ActionTokenStoreProvider create(KeycloakSession session) {
        return new InfinispanActionTokenStoreProvider(session, this.actionTokenCache);
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    private static Cache<ActionTokenReducedKey, ActionTokenValueEntity> initActionTokenCache(KeycloakSession session) {
        InfinispanConnectionProvider connections = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        Cache cache = connections.getCache("actionTokens");
        Address cacheAddress = cache.getCacheManager().getAddress();
        ClusterProvider cluster = (ClusterProvider)session.getProvider(ClusterProvider.class);
        cluster.registerListener(ACTION_TOKEN_EVENTS, event -> {
            RemoveActionTokensSpecificEvent e = (RemoveActionTokensSpecificEvent)event;
            LOG.debugf("[%s] Removing token invalidation for user+action: userId=%s, actionId=%s", (Object)cacheAddress, (Object)e.getUserId(), (Object)e.getActionId());
            AdvancedCache localCache = cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD});
            List<ActionTokenReducedKey> toRemove = localCache.keySet().stream().filter(k -> Objects.equals(k.getUserId(), e.getUserId()) && Objects.equals(k.getActionId(), e.getActionId())).collect(Collectors.toList());
            toRemove.forEach(arg_0 -> ((AdvancedCache)localCache).remove(arg_0));
        });
        LOG.debugf("[%s] Registered cluster listeners", (Object)cacheAddress);
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postInit(KeycloakSessionFactory factory) {
        Cache<ActionTokenReducedKey, ActionTokenValueEntity> cache = this.actionTokenCache;
        if (cache == null) {
            InfinispanActionTokenStoreProviderFactory infinispanActionTokenStoreProviderFactory = this;
            synchronized (infinispanActionTokenStoreProviderFactory) {
                cache = this.actionTokenCache;
                if (cache == null) {
                    this.actionTokenCache = InfinispanActionTokenStoreProviderFactory.initActionTokenCache(factory.create());
                }
            }
        }
    }

    public void close() {
    }

    public String getId() {
        return "infinispan";
    }
}

