/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.login.freemarker.model;

import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.HmacOTP;
import org.keycloak.utils.TotpUtils;

public class TotpBean {
    private final String totpSecret;
    private final String totpSecretEncoded;
    private final String totpSecretQrCode;
    private final boolean enabled;

    public TotpBean(KeycloakSession session, RealmModel realm, UserModel user) {
        this.enabled = session.userCredentialManager().isConfiguredFor(realm, user, "otp");
        this.totpSecret = HmacOTP.generateSecret((int)20);
        this.totpSecretEncoded = TotpUtils.encode(this.totpSecret);
        this.totpSecretQrCode = TotpUtils.qrCode(this.totpSecret, realm, user);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getTotpSecret() {
        return this.totpSecret;
    }

    public String getTotpSecretEncoded() {
        return this.totpSecretEncoded;
    }

    public String getTotpSecretQrCode() {
        return this.totpSecretQrCode;
    }
}

