/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys.loader;

import java.security.PublicKey;
import org.jboss.logging.Logger;
import org.keycloak.broker.oidc.OIDCIdentityProviderConfig;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.keys.PublicKeyLoader;
import org.keycloak.keys.PublicKeyStorageProvider;
import org.keycloak.keys.PublicKeyStorageUtils;
import org.keycloak.keys.loader.ClientPublicKeyLoader;
import org.keycloak.keys.loader.HardcodedPublicKeyLoader;
import org.keycloak.keys.loader.OIDCIdentityProviderPublicKeyLoader;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;

public class PublicKeyStorageManager {
    private static final Logger logger = Logger.getLogger(PublicKeyStorageManager.class);

    public static PublicKey getClientPublicKey(KeycloakSession session, ClientModel client, JWSInput input) {
        String kid = input.getHeader().getKeyId();
        PublicKeyStorageProvider keyStorage = (PublicKeyStorageProvider)session.getProvider(PublicKeyStorageProvider.class);
        String modelKey = PublicKeyStorageUtils.getClientModelCacheKey((String)client.getRealm().getId(), (String)client.getId());
        ClientPublicKeyLoader loader = new ClientPublicKeyLoader(session, client);
        return keyStorage.getPublicKey(modelKey, kid, (PublicKeyLoader)loader);
    }

    public static PublicKey getIdentityProviderPublicKey(KeycloakSession session, RealmModel realm, OIDCIdentityProviderConfig idpConfig, JWSInput input) {
        Object loader;
        boolean keyIdSetInConfiguration = idpConfig.getPublicKeySignatureVerifierKeyId() != null && !idpConfig.getPublicKeySignatureVerifierKeyId().trim().isEmpty();
        String kid = input.getHeader().getKeyId();
        PublicKeyStorageProvider keyStorage = (PublicKeyStorageProvider)session.getProvider(PublicKeyStorageProvider.class);
        String modelKey = PublicKeyStorageUtils.getIdpModelCacheKey((String)realm.getId(), (String)idpConfig.getInternalId());
        if (idpConfig.isUseJwksUrl()) {
            loader = new OIDCIdentityProviderPublicKeyLoader(session, idpConfig);
        } else {
            String pem = idpConfig.getPublicKeySignatureVerifier();
            if (pem == null || pem.trim().isEmpty()) {
                logger.warnf("No public key saved on identityProvider %s", (Object)idpConfig.getAlias());
                return null;
            }
            loader = new HardcodedPublicKeyLoader(keyIdSetInConfiguration ? idpConfig.getPublicKeySignatureVerifierKeyId().trim() : kid, pem);
        }
        return keyStorage.getPublicKey(modelKey, kid, (PublicKeyLoader)loader);
    }
}

