/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.evaluation;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.permission.ResourcePermission;

public class Result {
    private final ResourcePermission permission;
    private List<PolicyResult> results = new ArrayList<PolicyResult>();
    private Decision.Effect status;

    public Result(ResourcePermission permission) {
        this.permission = permission;
    }

    public ResourcePermission getPermission() {
        return this.permission;
    }

    public List<PolicyResult> getResults() {
        return this.results;
    }

    public PolicyResult policy(Policy policy) {
        for (PolicyResult result : this.results) {
            if (!result.getPolicy().equals(policy)) continue;
            return result;
        }
        PolicyResult policyResult = new PolicyResult(policy);
        this.results.add(policyResult);
        return policyResult;
    }

    public void setStatus(Decision.Effect status) {
        this.status = status;
    }

    public Decision.Effect getEffect() {
        return this.status;
    }

    public static class PolicyResult {
        private final Policy policy;
        private List<PolicyResult> associatedPolicies = new ArrayList<PolicyResult>();
        private Decision.Effect status;

        public PolicyResult(Policy policy) {
            this.policy = policy;
        }

        public PolicyResult status(Decision.Effect status) {
            this.status = status;
            return this;
        }

        public PolicyResult policy(Policy policy) {
            return this.getPolicy(policy, this.associatedPolicies);
        }

        private PolicyResult getPolicy(Policy policy, List<PolicyResult> results) {
            for (PolicyResult result : results) {
                if (!result.getPolicy().equals(policy)) continue;
                return result;
            }
            PolicyResult policyResult = new PolicyResult(policy);
            results.add(policyResult);
            return policyResult;
        }

        public Policy getPolicy() {
            return this.policy;
        }

        public List<PolicyResult> getAssociatedPolicies() {
            return this.associatedPolicies;
        }

        public Decision.Effect getStatus() {
            return this.status;
        }

        public void setStatus(Decision.Effect status) {
            this.status = status;
        }
    }
}

