/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.RealmModel;
import org.keycloak.models.cache.infinispan.events.AuthenticationSessionAuthNoteUpdateEvent;
import org.keycloak.models.sessions.infinispan.AuthenticationSessionAdapter;
import org.keycloak.models.sessions.infinispan.CacheDecorators;
import org.keycloak.models.sessions.infinispan.InfinispanKeycloakTransaction;
import org.keycloak.models.sessions.infinispan.entities.AuthenticationSessionEntity;
import org.keycloak.models.sessions.infinispan.events.ClientRemovedSessionEvent;
import org.keycloak.models.sessions.infinispan.events.RealmRemovedSessionEvent;
import org.keycloak.models.sessions.infinispan.events.SessionEventsSenderTransaction;
import org.keycloak.models.sessions.infinispan.stream.AuthenticationSessionPredicate;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RealmInfoUtil;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.AuthenticationSessionProvider;

public class InfinispanAuthenticationSessionProvider
implements AuthenticationSessionProvider {
    private static final Logger log = Logger.getLogger(InfinispanAuthenticationSessionProvider.class);
    private final KeycloakSession session;
    private final Cache<String, AuthenticationSessionEntity> cache;
    protected final InfinispanKeycloakTransaction tx;
    protected final SessionEventsSenderTransaction clusterEventsSenderTx;

    public InfinispanAuthenticationSessionProvider(KeycloakSession session, Cache<String, AuthenticationSessionEntity> cache) {
        this.session = session;
        this.cache = cache;
        this.tx = new InfinispanKeycloakTransaction();
        this.clusterEventsSenderTx = new SessionEventsSenderTransaction(session);
        session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)this.tx);
        session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)this.clusterEventsSenderTx);
    }

    public AuthenticationSessionModel createAuthenticationSession(RealmModel realm, ClientModel client) {
        String id = KeycloakModelUtils.generateId();
        return this.createAuthenticationSession(id, realm, client);
    }

    public AuthenticationSessionModel createAuthenticationSession(String id, RealmModel realm, ClientModel client) {
        AuthenticationSessionEntity entity = new AuthenticationSessionEntity();
        entity.setId(id);
        entity.setRealmId(realm.getId());
        entity.setTimestamp(Time.currentTime());
        entity.setClientUuid(client.getId());
        this.tx.put(this.cache, id, entity);
        AuthenticationSessionAdapter wrap = this.wrap(realm, entity);
        return wrap;
    }

    private AuthenticationSessionAdapter wrap(RealmModel realm, AuthenticationSessionEntity entity) {
        return entity == null ? null : new AuthenticationSessionAdapter(this.session, this, this.cache, realm, entity);
    }

    public AuthenticationSessionModel getAuthenticationSession(RealmModel realm, String authenticationSessionId) {
        AuthenticationSessionEntity entity = this.getAuthenticationSessionEntity(realm, authenticationSessionId);
        return this.wrap(realm, entity);
    }

    private AuthenticationSessionEntity getAuthenticationSessionEntity(RealmModel realm, String authSessionId) {
        AuthenticationSessionEntity entity = this.tx.get(this.cache, authSessionId);
        if (entity == null) {
            entity = (AuthenticationSessionEntity)this.cache.get((Object)authSessionId);
        }
        return entity;
    }

    public void removeAuthenticationSession(RealmModel realm, AuthenticationSessionModel authenticationSession) {
        this.tx.remove(this.cache, authenticationSession.getId());
    }

    public void removeExpired(RealmModel realm) {
        log.debugf("Removing expired sessions", new Object[0]);
        int expired = Time.currentTime() - RealmInfoUtil.getDettachedClientSessionLifespan((RealmModel)realm);
        Iterator itr = CacheDecorators.localCache(this.cache).entrySet().stream().filter((Predicate)AuthenticationSessionPredicate.create(realm.getId()).expired(expired)).iterator();
        int counter = 0;
        while (itr.hasNext()) {
            ++counter;
            AuthenticationSessionEntity entity = (AuthenticationSessionEntity)((Map.Entry)itr.next()).getValue();
            this.tx.remove(CacheDecorators.localCache(this.cache), entity.getId());
        }
        log.debugf("Removed %d expired authentication sessions for realm '%s'", counter, (Object)realm.getName());
    }

    public void onRealmRemoved(RealmModel realm) {
        this.clusterEventsSenderTx.addEvent(RealmRemovedSessionEvent.createEvent(RealmRemovedSessionEvent.class, "REALM_REMOVED_EVENT_AUTHSESSIONS", this.session, realm.getId(), false), ClusterProvider.DCNotify.ALL_DCS);
    }

    protected void onRealmRemovedEvent(String realmId) {
        Iterator itr = CacheDecorators.localCache(this.cache).entrySet().stream().filter((Predicate)AuthenticationSessionPredicate.create(realmId)).iterator();
        while (itr.hasNext()) {
            CacheDecorators.localCache(this.cache).remove(((Map.Entry)itr.next()).getKey());
        }
    }

    public void onClientRemoved(RealmModel realm, ClientModel client) {
        this.clusterEventsSenderTx.addEvent(ClientRemovedSessionEvent.create(this.session, "CLIENT_REMOVED_SESSION_AUTHSESSIONS", realm.getId(), false, client.getId()), ClusterProvider.DCNotify.ALL_DCS);
    }

    protected void onClientRemovedEvent(String realmId, String clientUuid) {
        Iterator itr = CacheDecorators.localCache(this.cache).entrySet().stream().filter((Predicate)AuthenticationSessionPredicate.create(realmId).client(clientUuid)).iterator();
        while (itr.hasNext()) {
            CacheDecorators.localCache(this.cache).remove(((Map.Entry)itr.next()).getKey());
        }
    }

    public void updateNonlocalSessionAuthNotes(String authSessionId, Map<String, String> authNotesFragment) {
        if (authSessionId == null) {
            return;
        }
        ClusterProvider cluster = (ClusterProvider)this.session.getProvider(ClusterProvider.class);
        cluster.notify("AUTHENTICATION_SESSION_EVENTS", (ClusterEvent)AuthenticationSessionAuthNoteUpdateEvent.create(authSessionId, authNotesFragment), true, ClusterProvider.DCNotify.ALL_BUT_LOCAL_DC);
    }

    public void close() {
    }

    public Cache<String, AuthenticationSessionEntity> getCache() {
        return this.cache;
    }
}

