/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.remotestore;

import java.util.Random;
import java.util.concurrent.ExecutorService;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.VersionedValue;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryCreatedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryModifiedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryRemovedEvent;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.context.Flag;
import org.jboss.logging.Logger;
import org.keycloak.executors.ExecutorsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.remotestore.ClientListenerExecutorDecorator;
import org.keycloak.models.sessions.infinispan.util.InfinispanUtil;

@ClientListener
public class RemoteCacheSessionListener<K, V extends SessionEntity> {
    protected static final Logger logger = Logger.getLogger(RemoteCacheSessionListener.class);
    private Cache<K, SessionEntityWrapper<V>> cache;
    private RemoteCache<K, SessionEntityWrapper<V>> remoteCache;
    private boolean distributed;
    private String myAddress;
    private ClientListenerExecutorDecorator<K> executor;
    private static final int MAXIMUM_REPLACE_RETRIES = 10;

    protected RemoteCacheSessionListener() {
    }

    protected void init(KeycloakSession session, Cache<K, SessionEntityWrapper<V>> cache, RemoteCache<K, SessionEntityWrapper<V>> remoteCache) {
        this.cache = cache;
        this.remoteCache = remoteCache;
        this.distributed = InfinispanUtil.isDistributedCache(cache);
        this.myAddress = this.distributed ? InfinispanUtil.getMyAddress(session) : null;
        ExecutorService executor = ((ExecutorsProvider)session.getProvider(ExecutorsProvider.class)).getExecutor("client-listener-" + cache.getName());
        this.executor = new ClientListenerExecutorDecorator(executor);
    }

    @ClientCacheEntryCreated
    public void created(ClientCacheEntryCreatedEvent event) {
        Object key = event.getKey();
        if (this.shouldUpdateLocalCache(event.getType(), key, event.isCommandRetried())) {
            this.executor.submit(event, () -> this.cache.get(key));
        }
    }

    @ClientCacheEntryModified
    public void updated(ClientCacheEntryModifiedEvent event) {
        Object key = event.getKey();
        if (this.shouldUpdateLocalCache(event.getType(), key, event.isCommandRetried())) {
            this.executor.submit(event, () -> this.replaceRemoteEntityInCache(key, event.getVersion()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceRemoteEntityInCache(K key, long eventVersion) {
        boolean replaced = false;
        int replaceRetries = 0;
        int sleepInterval = 25;
        do {
            ++replaceRetries;
            SessionEntityWrapper localEntityWrapper = (SessionEntityWrapper)this.cache.get(key);
            VersionedValue remoteSessionVersioned = this.remoteCache.getVersioned(key);
            if (remoteSessionVersioned == null || remoteSessionVersioned.getValue() == null) {
                logger.debugf("Entity '%s' not present in remoteCache. Ignoring replace", (Object)key.toString());
                return;
            }
            if (remoteSessionVersioned.getVersion() < eventVersion) {
                try {
                    logger.debugf("Got replace remote entity event prematurely for entity '%s', will try again. Event version: %d, got: %d", (Object)key.toString(), (Object)eventVersion, (Object)(remoteSessionVersioned == null ? -1L : remoteSessionVersioned.getVersion()));
                    Thread.sleep(new Random().nextInt(sleepInterval));
                }
                catch (InterruptedException ex) {
                }
                finally {
                    sleepInterval <<= 1;
                }
            } else {
                Object remoteSession = ((SessionEntityWrapper)remoteSessionVersioned.getValue()).getEntity();
                logger.debugf("Read session entity from the remote cache: %s . replaceRetries=%d", (Object)remoteSession.toString(), (Object)replaceRetries);
                SessionEntityWrapper sessionWrapper = ((SessionEntity)remoteSession).mergeRemoteEntityWithLocalEntity(localEntityWrapper);
                replaced = this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE, Flag.SKIP_CACHE_LOAD, Flag.IGNORE_RETURN_VALUES}).replace(key, (Object)localEntityWrapper, (Object)sessionWrapper);
                if (replaced) continue;
                logger.debugf("Did not succeed in merging sessions, will try again: %s", (Object)remoteSession.toString());
            }
        } while (replaceRetries < 10 && !replaced);
    }

    @ClientCacheEntryRemoved
    public void removed(ClientCacheEntryRemovedEvent event) {
        Object key = event.getKey();
        if (this.shouldUpdateLocalCache(event.getType(), key, event.isCommandRetried())) {
            this.executor.submit(event, () -> this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE, Flag.SKIP_CACHE_LOAD, Flag.IGNORE_RETURN_VALUES}).remove(key));
        }
    }

    protected boolean shouldUpdateLocalCache(ClientEvent.Type type, K key, boolean commandRetried) {
        boolean result;
        if (!this.cache.getStatus().allowInvocations()) {
            return false;
        }
        if (!this.distributed || commandRetried) {
            result = true;
        } else {
            String keyAddress = InfinispanUtil.getKeyPrimaryOwnerAddress(this.cache, key);
            result = this.myAddress.equals(keyAddress);
        }
        logger.debugf("Received event from remote store. Event '%s', key '%s', skip '%b'", (Object)type.toString(), key, (Object)(!result ? 1 : 0));
        return result;
    }

    public static <K, V extends SessionEntity> RemoteCacheSessionListener createListener(KeycloakSession session, Cache<K, SessionEntityWrapper<V>> cache, RemoteCache<K, SessionEntityWrapper<V>> remoteCache) {
        RemoteCacheSessionListener<K, V> listener = new RemoteCacheSessionListener<K, V>();
        listener.init(session, cache, remoteCache);
        return listener;
    }

    @ClientListener(includeCurrentState=false)
    public static class DontFetchInitialStateCacheListener
    extends RemoteCacheSessionListener {
    }

    @ClientListener(includeCurrentState=true)
    public static class FetchInitialStateCacheListener
    extends RemoteCacheSessionListener {
    }
}

