/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.stream;

import java.io.Serializable;
import java.util.Map;
import java.util.function.Predicate;
import org.keycloak.models.sessions.infinispan.entities.AuthenticationSessionEntity;

public class AuthenticationSessionPredicate
implements Predicate<Map.Entry<String, AuthenticationSessionEntity>>,
Serializable {
    private String realm;
    private String client;
    private String user;
    private Integer expired;

    private AuthenticationSessionPredicate(String realm) {
        this.realm = realm;
    }

    public static AuthenticationSessionPredicate create(String realm) {
        return new AuthenticationSessionPredicate(realm);
    }

    public AuthenticationSessionPredicate user(String user) {
        this.user = user;
        return this;
    }

    public AuthenticationSessionPredicate client(String client) {
        this.client = client;
        return this;
    }

    public AuthenticationSessionPredicate expired(Integer expired) {
        this.expired = expired;
        return this;
    }

    @Override
    public boolean test(Map.Entry<String, AuthenticationSessionEntity> entry) {
        AuthenticationSessionEntity entity = entry.getValue();
        if (!this.realm.equals(entity.getRealmId())) {
            return false;
        }
        if (this.user != null && !entity.getAuthUserId().equals(this.user)) {
            return false;
        }
        if (this.client != null && !entity.getClientUuid().equals(this.client)) {
            return false;
        }
        return this.expired == null || entity.getTimestamp() <= this.expired;
    }
}

