/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.lang;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.drools.compiler.compiler.DroolsParserException;
import org.drools.compiler.lang.DroolsEditorType;
import org.drools.compiler.lang.DroolsParaphraseTypes;
import org.drools.compiler.lang.DroolsParserExceptionFactory;
import org.drools.compiler.lang.DroolsSentence;
import org.drools.compiler.lang.DroolsSentenceType;
import org.drools.compiler.lang.DroolsSoftKeywords;
import org.drools.compiler.lang.DroolsToken;
import org.drools.compiler.lang.api.AbstractClassTypeDeclarationBuilder;
import org.drools.compiler.lang.api.AccumulateDescrBuilder;
import org.drools.compiler.lang.api.AccumulateImportDescrBuilder;
import org.drools.compiler.lang.api.AttributeDescrBuilder;
import org.drools.compiler.lang.api.AttributeSupportBuilder;
import org.drools.compiler.lang.api.BehaviorDescrBuilder;
import org.drools.compiler.lang.api.CEDescrBuilder;
import org.drools.compiler.lang.api.CollectDescrBuilder;
import org.drools.compiler.lang.api.ConditionalBranchDescrBuilder;
import org.drools.compiler.lang.api.DeclareDescrBuilder;
import org.drools.compiler.lang.api.DescrBuilder;
import org.drools.compiler.lang.api.DescrFactory;
import org.drools.compiler.lang.api.EntryPointDeclarationDescrBuilder;
import org.drools.compiler.lang.api.EnumDeclarationDescrBuilder;
import org.drools.compiler.lang.api.EnumLiteralDescrBuilder;
import org.drools.compiler.lang.api.EvalDescrBuilder;
import org.drools.compiler.lang.api.FieldDescrBuilder;
import org.drools.compiler.lang.api.ForallDescrBuilder;
import org.drools.compiler.lang.api.FunctionDescrBuilder;
import org.drools.compiler.lang.api.GlobalDescrBuilder;
import org.drools.compiler.lang.api.ImportDescrBuilder;
import org.drools.compiler.lang.api.NamedConsequenceDescrBuilder;
import org.drools.compiler.lang.api.PackageDescrBuilder;
import org.drools.compiler.lang.api.PatternContainerDescrBuilder;
import org.drools.compiler.lang.api.PatternDescrBuilder;
import org.drools.compiler.lang.api.QueryDescrBuilder;
import org.drools.compiler.lang.api.RuleDescrBuilder;
import org.drools.compiler.lang.api.TypeDeclarationDescrBuilder;
import org.drools.compiler.lang.api.WindowDeclarationDescrBuilder;
import org.drools.compiler.lang.descr.AttributeDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.kie.internal.builder.conf.LanguageLevelOption;

public class ParserHelper {
    public final String[] statementKeywords = new String[]{"package", "import", "global", "declare", "function", "rule", "query"};
    public List<DroolsParserException> errors = new ArrayList<DroolsParserException>();
    public LinkedList<DroolsSentence> editorInterface = null;
    public boolean isEditorInterfaceEnabled = false;
    private Stack<Map<DroolsParaphraseTypes, String>> paraphrases = new Stack();
    private DroolsParserExceptionFactory errorMessageFactory = null;
    private TokenStream input = null;
    private RecognizerSharedState state = null;
    private String leftMostExpr = null;
    private boolean hasOperator = false;
    private final LanguageLevelOption languageLevel;

    public ParserHelper(TokenStream input, RecognizerSharedState state, LanguageLevelOption languageLevel) {
        this.errorMessageFactory = new DroolsParserExceptionFactory(this.paraphrases, languageLevel);
        this.input = input;
        this.state = state;
        this.languageLevel = languageLevel;
    }

    public LinkedList<DroolsSentence> getEditorInterface() {
        return this.editorInterface;
    }

    public void setLeftMostExpr(String value) {
        this.leftMostExpr = value;
    }

    public String getLeftMostExpr() {
        return this.leftMostExpr;
    }

    public void enableEditorInterface() {
        this.isEditorInterfaceEnabled = true;
    }

    public void disableEditorInterface() {
        this.isEditorInterfaceEnabled = false;
    }

    public void setHasOperator(boolean hasOperator) {
        this.hasOperator = hasOperator;
    }

    public boolean getHasOperator() {
        return this.hasOperator;
    }

    public void beginSentence(DroolsSentenceType sentenceType) {
        if (this.isEditorInterfaceEnabled) {
            if (null == this.editorInterface) {
                this.editorInterface = new LinkedList();
            }
            if (this.editorInterface.isEmpty()) {
                DroolsSentence sentence = new DroolsSentence();
                sentence.setType(sentenceType);
                this.editorInterface.add(sentence);
            }
        }
    }

    public DroolsSentence getActiveSentence() {
        return this.editorInterface.getLast();
    }

    public void emit(List<?> tokens, DroolsEditorType editorType) {
        if (this.isEditorInterfaceEnabled && tokens != null) {
            for (Object activeObject : tokens) {
                this.emit((Token)activeObject, editorType);
            }
        }
    }

    public void emit(Token token, DroolsEditorType editorType) {
        if (this.isEditorInterfaceEnabled && token != null && editorType != null) {
            ((DroolsToken)token).setEditorType(editorType);
            this.getActiveSentence().addContent((DroolsToken)token);
        }
    }

    public void emit(int activeContext) {
        if (this.isEditorInterfaceEnabled) {
            this.getActiveSentence().addContent(activeContext);
        }
    }

    public DroolsToken getLastTokenOnList(LinkedList<?> list) {
        DroolsToken lastToken = null;
        for (Object object : list) {
            if (!(object instanceof DroolsToken)) continue;
            lastToken = (DroolsToken)((Object)object);
        }
        return lastToken;
    }

    public String retrieveLT(int LTNumber) {
        if (null == this.input) {
            return null;
        }
        if (null == this.input.LT(LTNumber)) {
            return null;
        }
        if (null == this.input.LT(LTNumber).getText()) {
            return null;
        }
        return this.input.LT(LTNumber).getText();
    }

    public boolean validateLT(int LTNumber, String text) {
        String text2Validate = this.retrieveLT(LTNumber);
        return this.validateText(text, text2Validate);
    }

    private boolean validateText(String text, String text2Validate) {
        return text2Validate != null && text2Validate.equals(text);
    }

    public boolean isPluggableEvaluator(int offset, boolean negated) {
        String text2Validate = this.retrieveLT(offset);
        return text2Validate != null && DroolsSoftKeywords.isOperator(text2Validate, negated);
    }

    public boolean isPluggableEvaluator(boolean negated) {
        return this.isPluggableEvaluator(1, negated);
    }

    public boolean validateIdentifierKey(String text) {
        return this.validateLT(1, text);
    }

    public boolean validateCEKeyword(int index) {
        String text2Validate = this.retrieveLT(index);
        return this.validateText(text2Validate, "not") || this.validateText(text2Validate, "exists") || this.validateText(text2Validate, "forall") || this.validateText(text2Validate, "and") || this.validateText(text2Validate, "or") || this.validateText(text2Validate, "collect") || this.validateText(text2Validate, "from") || this.validateText(text2Validate, "end") || this.validateText(text2Validate, "eval") || this.validateText(text2Validate, "over") || this.validateText(text2Validate, "then");
    }

    public boolean validateStatement(int index) {
        boolean ret = false;
        String text2Validate = this.retrieveLT(index);
        for (String st : this.statementKeywords) {
            if (!this.validateText(text2Validate, st)) continue;
            ret = true;
            break;
        }
        return ret || this.validateAttribute(index);
    }

    public boolean validateAttribute(int index) {
        String text2Validate = this.retrieveLT(index);
        return this.validateText(text2Validate, "salience") || this.validateText(text2Validate, "enabled") || this.validateText(text2Validate, "no") && this.validateLT(index + 1, "-") && this.validateLT(index + 2, "loop") || this.validateText(text2Validate, "auto") && this.validateLT(index + 1, "-") && this.validateLT(index + 2, "focus") || this.validateText(text2Validate, "lock") && this.validateLT(index + 1, "-") && this.validateLT(index + 2, "on") && this.validateLT(index + 3, "-") && this.validateLT(index + 4, "active") || this.validateText(text2Validate, "agenda") && this.validateLT(index + 1, "-") && this.validateLT(index + 2, "group") || this.validateText(text2Validate, "activation") && this.validateLT(index + 1, "-") && this.validateLT(index + 2, "group") || this.validateText(text2Validate, "ruleflow") && this.validateLT(index + 1, "-") && this.validateLT(index + 2, "group") || this.validateText(text2Validate, "date") && this.validateLT(index + 1, "-") && this.validateLT(index + 2, "effective") || this.validateText(text2Validate, "date") && this.validateLT(index + 1, "-") && this.validateLT(index + 2, "expires") || this.validateText(text2Validate, "dialect") || this.validateText(text2Validate, "calendars") || this.validateText(text2Validate, "timer") || this.validateText(text2Validate, "duration") || this.validateText(text2Validate, "refract") || this.validateText(text2Validate, "direct");
    }

    public void reportError(RecognitionException ex) {
        if (this.state.errorRecovery) {
            return;
        }
        this.state.errorRecovery = true;
        this.errors.add(this.errorMessageFactory.createDroolsException(ex));
    }

    public void reportError(Exception e) {
        try {
            this.errors.add(this.errorMessageFactory.createDroolsException(e, this.input.LT(1)));
        }
        catch (Exception ignored) {
            this.errors.add(new DroolsParserException("Unexpected error: " + e.getMessage(), e));
        }
    }

    public List<DroolsParserException> getErrors() {
        return this.errors;
    }

    public List<String> getErrorMessages() {
        ArrayList<String> messages = new ArrayList<String>(this.errors.size());
        for (DroolsParserException activeException : this.errors) {
            messages.add(activeException.getMessage());
        }
        return messages;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public void pushParaphrases(DroolsParaphraseTypes type) {
        HashMap<DroolsParaphraseTypes, String> activeMap = new HashMap<DroolsParaphraseTypes, String>();
        activeMap.put(type, "");
        this.paraphrases.push(activeMap);
    }

    public Map<DroolsParaphraseTypes, String> popParaphrases() {
        return this.paraphrases.pop();
    }

    public void setParaphrasesValue(DroolsParaphraseTypes type, String value) {
        this.paraphrases.peek().put(type, value);
    }

    void setStart(DescrBuilder<?, ?> db) {
        this.setStart(db, this.input.LT(1));
    }

    void setStart(DescrBuilder<?, ?> db, Token first) {
        if (db != null && first != null) {
            db.startCharacter(((CommonToken)first).getStartIndex()).startLocation(first.getLine(), first.getCharPositionInLine());
        }
    }

    void setStart(BaseDescr descr, Token first) {
        if (descr != null && first != null) {
            descr.setLocation(first.getLine(), first.getCharPositionInLine());
            descr.setStartCharacter(((CommonToken)first).getStartIndex());
        }
    }

    void setEnd(BaseDescr descr) {
        Token last = this.input.LT(-1);
        if (descr != null && last != null) {
            int endLocation = last.getText() != null ? last.getCharPositionInLine() + last.getText().length() - 1 : last.getCharPositionInLine();
            descr.setEndCharacter(((CommonToken)last).getStopIndex() + 1);
            descr.setEndLocation(last.getLine(), endLocation);
        }
    }

    void setEnd(DescrBuilder<?, ?> db) {
        Token last = this.input.LT(-1);
        if (db != null && last != null) {
            int endLocation = last.getText() != null ? last.getCharPositionInLine() + last.getText().length() - 1 : last.getCharPositionInLine();
            db.endCharacter(((CommonToken)last).getStopIndex() + 1).endLocation(last.getLine(), endLocation);
        }
    }

    public <T extends DescrBuilder<?, ?>> T start(DescrBuilder<?, ?> ctxBuilder, Class<T> clazz, String param) {
        if (this.state.backtracking == 0) {
            if (PackageDescrBuilder.class.isAssignableFrom(clazz)) {
                this.pushParaphrases(DroolsParaphraseTypes.PACKAGE);
                this.beginSentence(DroolsSentenceType.PACKAGE);
                this.setStart(ctxBuilder);
            } else {
                if (ImportDescrBuilder.class.isAssignableFrom(clazz)) {
                    ImportDescrBuilder imp = this.validateLT(2, "function") || this.validateLT(2, "static") ? (ctxBuilder == null ? DescrFactory.newPackage().newFunctionImport() : ((PackageDescrBuilder)ctxBuilder).newFunctionImport()) : (ctxBuilder == null ? DescrFactory.newPackage().newImport() : ((PackageDescrBuilder)ctxBuilder).newImport());
                    this.pushParaphrases(DroolsParaphraseTypes.IMPORT);
                    this.beginSentence(DroolsSentenceType.IMPORT_STATEMENT);
                    this.setStart(imp);
                    return (T)imp;
                }
                if (AccumulateImportDescrBuilder.class.isAssignableFrom(clazz)) {
                    AccumulateImportDescrBuilder imp = ctxBuilder == null ? DescrFactory.newPackage().newAccumulateImport() : ((PackageDescrBuilder)ctxBuilder).newAccumulateImport();
                    this.pushParaphrases(DroolsParaphraseTypes.ACCUMULATE_IMPORT);
                    this.beginSentence(DroolsSentenceType.ACCUMULATE_IMPORT_STATEMENT);
                    this.setStart(imp);
                    return (T)imp;
                }
                if (GlobalDescrBuilder.class.isAssignableFrom(clazz)) {
                    GlobalDescrBuilder global = ctxBuilder == null ? DescrFactory.newPackage().newGlobal() : ((PackageDescrBuilder)ctxBuilder).newGlobal();
                    this.pushParaphrases(DroolsParaphraseTypes.GLOBAL);
                    this.beginSentence(DroolsSentenceType.GLOBAL);
                    this.setStart(global);
                    return (T)global;
                }
                if (DeclareDescrBuilder.class.isAssignableFrom(clazz)) {
                    DeclareDescrBuilder declare = ctxBuilder == null ? DescrFactory.newPackage().newDeclare() : ((PackageDescrBuilder)ctxBuilder).newDeclare();
                    return (T)declare;
                }
                if (TypeDeclarationDescrBuilder.class.isAssignableFrom(clazz)) {
                    TypeDeclarationDescrBuilder declare = ctxBuilder == null ? DescrFactory.newPackage().newDeclare().type() : ((DeclareDescrBuilder)ctxBuilder).type();
                    this.pushParaphrases(DroolsParaphraseTypes.TYPE_DECLARE);
                    this.beginSentence(DroolsSentenceType.TYPE_DECLARATION);
                    this.setStart(declare);
                    return (T)declare;
                }
                if (EnumDeclarationDescrBuilder.class.isAssignableFrom(clazz)) {
                    EnumDeclarationDescrBuilder declare = ctxBuilder == null ? DescrFactory.newPackage().newDeclare().enumerative() : ((DeclareDescrBuilder)ctxBuilder).enumerative();
                    this.pushParaphrases(DroolsParaphraseTypes.ENUM_DECLARE);
                    this.beginSentence(DroolsSentenceType.ENUM_DECLARATION);
                    this.setStart(declare);
                    return (T)declare;
                }
                if (EntryPointDeclarationDescrBuilder.class.isAssignableFrom(clazz)) {
                    EntryPointDeclarationDescrBuilder declare = ctxBuilder == null ? DescrFactory.newPackage().newDeclare().entryPoint() : ((DeclareDescrBuilder)ctxBuilder).entryPoint();
                    this.pushParaphrases(DroolsParaphraseTypes.ENTRYPOINT_DECLARE);
                    this.beginSentence(DroolsSentenceType.ENTRYPOINT_DECLARATION);
                    this.setStart(declare);
                    return (T)declare;
                }
                if (WindowDeclarationDescrBuilder.class.isAssignableFrom(clazz)) {
                    WindowDeclarationDescrBuilder declare = ctxBuilder == null ? DescrFactory.newPackage().newDeclare().window() : ((DeclareDescrBuilder)ctxBuilder).window();
                    this.pushParaphrases(DroolsParaphraseTypes.WINDOW_DECLARE);
                    this.beginSentence(DroolsSentenceType.WINDOW_DECLARATION);
                    this.setStart(declare);
                    return (T)declare;
                }
                if (FieldDescrBuilder.class.isAssignableFrom(clazz)) {
                    FieldDescrBuilder field = ((AbstractClassTypeDeclarationBuilder)ctxBuilder).newField(param);
                    this.setStart(field);
                    return (T)field;
                }
                if (EnumLiteralDescrBuilder.class.isAssignableFrom(clazz)) {
                    EnumLiteralDescrBuilder literal = ((EnumDeclarationDescrBuilder)ctxBuilder).newEnumLiteral(param);
                    this.setStart(literal);
                    return (T)literal;
                }
                if (FunctionDescrBuilder.class.isAssignableFrom(clazz)) {
                    FunctionDescrBuilder function;
                    if (ctxBuilder == null) {
                        function = DescrFactory.newPackage().newFunction();
                    } else {
                        PackageDescrBuilder pkg = (PackageDescrBuilder)ctxBuilder;
                        function = pkg.newFunction().namespace(((PackageDescr)pkg.getDescr()).getName());
                        AttributeDescr attribute = ((PackageDescr)pkg.getDescr()).getAttribute("dialect");
                        if (attribute != null) {
                            function.dialect(attribute.getValue());
                        }
                    }
                    this.pushParaphrases(DroolsParaphraseTypes.FUNCTION);
                    this.beginSentence(DroolsSentenceType.FUNCTION);
                    this.setStart(function);
                    return (T)function;
                }
                if (RuleDescrBuilder.class.isAssignableFrom(clazz)) {
                    RuleDescrBuilder rule = ctxBuilder == null ? DescrFactory.newPackage().newRule() : ((PackageDescrBuilder)ctxBuilder).newRule();
                    this.pushParaphrases(DroolsParaphraseTypes.RULE);
                    this.beginSentence(DroolsSentenceType.RULE);
                    this.setStart(rule);
                    return (T)rule;
                }
                if (QueryDescrBuilder.class.isAssignableFrom(clazz)) {
                    QueryDescrBuilder query = ctxBuilder == null ? DescrFactory.newPackage().newQuery() : ((PackageDescrBuilder)ctxBuilder).newQuery();
                    this.pushParaphrases(DroolsParaphraseTypes.QUERY);
                    this.beginSentence(DroolsSentenceType.QUERY);
                    this.setStart(query);
                    return (T)query;
                }
                if (AttributeDescrBuilder.class.isAssignableFrom(clazz)) {
                    AttributeDescrBuilder attribute = ((AttributeSupportBuilder)((Object)ctxBuilder)).attribute(param);
                    this.setStart(attribute);
                    return (T)attribute;
                }
                if (EvalDescrBuilder.class.isAssignableFrom(clazz)) {
                    EvalDescrBuilder eval = ((CEDescrBuilder)ctxBuilder).eval();
                    this.pushParaphrases(DroolsParaphraseTypes.EVAL);
                    this.beginSentence(DroolsSentenceType.EVAL);
                    this.setStart(eval);
                    return (T)eval;
                }
                if (ForallDescrBuilder.class.isAssignableFrom(clazz)) {
                    ForallDescrBuilder forall = ((CEDescrBuilder)ctxBuilder).forall();
                    this.setStart(forall);
                    return (T)forall;
                }
                if (CEDescrBuilder.class.isAssignableFrom(clazz)) {
                    this.setStart(ctxBuilder);
                    return (T)ctxBuilder;
                }
                if (PatternDescrBuilder.class.isAssignableFrom(clazz)) {
                    PatternDescrBuilder pattern = ((PatternContainerDescrBuilder)((Object)ctxBuilder)).pattern();
                    this.pushParaphrases(DroolsParaphraseTypes.PATTERN);
                    this.setStart(pattern);
                    return (T)pattern;
                }
                if (CollectDescrBuilder.class.isAssignableFrom(clazz)) {
                    CollectDescrBuilder collect = ((PatternDescrBuilder)ctxBuilder).from().collect();
                    this.setStart(collect);
                    return (T)collect;
                }
                if (AccumulateDescrBuilder.class.isAssignableFrom(clazz)) {
                    AccumulateDescrBuilder accumulate = ((PatternDescrBuilder)ctxBuilder).from().accumulate();
                    this.setStart(accumulate);
                    return (T)accumulate;
                }
                if (BehaviorDescrBuilder.class.isAssignableFrom(clazz)) {
                    BehaviorDescrBuilder behavior = ((PatternDescrBuilder)ctxBuilder).behavior();
                    this.setStart(behavior);
                    return (T)behavior;
                }
                if (NamedConsequenceDescrBuilder.class.isAssignableFrom(clazz)) {
                    NamedConsequenceDescrBuilder namedConsequence = ((CEDescrBuilder)ctxBuilder).namedConsequence();
                    this.setStart(namedConsequence);
                    return (T)namedConsequence;
                }
                if (ConditionalBranchDescrBuilder.class.isAssignableFrom(clazz)) {
                    ConditionalBranchDescrBuilder conditionalBranch = ((CEDescrBuilder)ctxBuilder).conditionalBranch();
                    this.setStart(conditionalBranch);
                    return (T)conditionalBranch;
                }
            }
        }
        return null;
    }

    public <T extends DescrBuilder<?, ?>> T end(Class<T> clazz, DescrBuilder<?, ?> builder) {
        if (this.state.backtracking == 0) {
            if (!(FieldDescrBuilder.class.isAssignableFrom(clazz) || AttributeDescrBuilder.class.isAssignableFrom(clazz) || CEDescrBuilder.class.isAssignableFrom(clazz) || CollectDescrBuilder.class.isAssignableFrom(clazz) || AccumulateDescrBuilder.class.isAssignableFrom(clazz) || ForallDescrBuilder.class.isAssignableFrom(clazz) || BehaviorDescrBuilder.class.isAssignableFrom(clazz) || ConditionalBranchDescrBuilder.class.isAssignableFrom(clazz) || NamedConsequenceDescrBuilder.class.isAssignableFrom(clazz))) {
                this.popParaphrases();
            }
            if (RuleDescrBuilder.class.isAssignableFrom(clazz)) {
                RuleDescrBuilder ruleDescrBuilder = (RuleDescrBuilder)builder;
                ((PackageDescr)((PackageDescrBuilder)ruleDescrBuilder.end()).getDescr()).afterRuleAdded((RuleDescr)ruleDescrBuilder.getDescr());
            }
            this.setEnd(builder);
            return (T)builder;
        }
        return null;
    }

    public String[] getStatementKeywords() {
        return this.statementKeywords;
    }
}

