/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol;

import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.RestartLoginCookie;
import org.keycloak.services.ErrorPageException;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.managers.UserSessionCrossDCManager;
import org.keycloak.services.util.AuthenticationFlowURLHelper;
import org.keycloak.services.util.CacheControlUtil;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;

public abstract class AuthorizationEndpointBase {
    private static final Logger logger = Logger.getLogger(AuthorizationEndpointBase.class);
    public static final String APP_INITIATED_FLOW = "APP_INITIATED_FLOW";
    protected RealmModel realm;
    protected EventBuilder event;
    protected AuthenticationManager authManager;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpHeaders headers;
    @Context
    protected HttpRequest httpRequest;
    @Context
    protected KeycloakSession session;
    @Context
    protected ClientConnection clientConnection;

    public AuthorizationEndpointBase(RealmModel realm, EventBuilder event) {
        this.realm = realm;
        this.event = event;
    }

    protected AuthenticationProcessor createProcessor(AuthenticationSessionModel authSession, String flowId, String flowPath) {
        AuthenticationProcessor processor = new AuthenticationProcessor();
        processor.setAuthenticationSession(authSession).setFlowPath(flowPath).setFlowId(flowId).setBrowserFlow(true).setConnection(this.clientConnection).setEventBuilder(this.event).setRealm(this.realm).setSession(this.session).setUriInfo(this.uriInfo).setRequest(this.httpRequest);
        authSession.setAuthNote("current.flow.path", flowPath);
        return processor;
    }

    protected Response handleBrowserAuthenticationRequest(AuthenticationSessionModel authSession, LoginProtocol protocol, boolean isPassive, boolean redirectToAuthentication) {
        AuthenticationFlowModel flow = this.getAuthenticationFlow();
        String flowId = flow.getId();
        AuthenticationProcessor processor = this.createProcessor(authSession, flowId, "authenticate");
        this.event.detail("code_id", authSession.getId());
        if (isPassive) {
            try {
                if (processor.authenticateOnly() != null) {
                    Response response = protocol.sendError(authSession, LoginProtocol.Error.PASSIVE_LOGIN_REQUIRED);
                    return response;
                }
                AuthenticationManager.setRolesAndMappersInSession(authSession);
                if (processor.nextRequiredAction() != null) {
                    Response response = protocol.sendError(authSession, LoginProtocol.Error.PASSIVE_INTERACTION_REQUIRED);
                    return response;
                }
                processor.attachSession();
            }
            catch (Exception e) {
                return processor.handleBrowserException(e);
            }
            return processor.finishAuthentication(protocol);
        }
        try {
            RestartLoginCookie.setRestartCookie(this.session, this.realm, this.clientConnection, this.uriInfo, authSession);
            if (redirectToAuthentication) {
                return processor.redirectToFlow();
            }
            return processor.authenticate();
        }
        catch (Exception e) {
            return processor.handleBrowserException(e);
        }
    }

    protected AuthenticationFlowModel getAuthenticationFlow() {
        return this.realm.getBrowserFlow();
    }

    protected void checkSsl() {
        if (!this.uriInfo.getBaseUri().getScheme().equals("https") && this.realm.getSslRequired().isRequired(this.clientConnection)) {
            this.event.error("ssl_required");
            throw new ErrorPageException(this.session, "httpsRequiredMessage", new Object[0]);
        }
    }

    protected void checkRealm() {
        if (!this.realm.isEnabled()) {
            this.event.error("realm_disabled");
            throw new ErrorPageException(this.session, "realmNotEnabledMessage", new Object[0]);
        }
    }

    protected AuthorizationEndpointChecks getOrCreateAuthenticationSession(ClientModel client, String requestState) {
        UserSessionModel userSession;
        AuthenticationSessionModel authSession;
        AuthenticationSessionManager manager = new AuthenticationSessionManager(this.session);
        String authSessionId = manager.getCurrentAuthenticationSessionId(this.realm);
        AuthenticationSessionModel authenticationSessionModel = authSession = authSessionId == null ? null : this.session.authenticationSessions().getAuthenticationSession(this.realm, authSessionId);
        if (authSession != null) {
            ClientSessionCode<AuthenticationSessionModel> check = new ClientSessionCode<AuthenticationSessionModel>(this.session, this.realm, authSession);
            if (!check.isActionActive(ClientSessionCode.ActionType.LOGIN)) {
                logger.debugf("Authentication session '%s' exists, but is expired. Restart existing authentication session", (Object)authSession.getId());
                authSession.restartSession(this.realm, client);
                return new AuthorizationEndpointChecks(authSession);
            }
            if (this.isNewRequest(authSession, client, requestState)) {
                if (this.shouldRestartAuthSession(authSession)) {
                    logger.debug((Object)"New request from application received, but authentication session already exists. Restart existing authentication session");
                    authSession.restartSession(this.realm, client);
                } else {
                    logger.debug((Object)"New request from application received, but authentication session already exists. Update client information in existing authentication session");
                    authSession.clearClientNotes();
                    authSession.updateClient(client);
                }
                return new AuthorizationEndpointChecks(authSession);
            }
            logger.debug((Object)"Re-sent some previous request to Authorization endpoint. Likely browser 'back' or 'refresh' button.");
            if (!this.shouldShowExpirePage(authSession)) {
                return new AuthorizationEndpointChecks(authSession);
            }
            CacheControlUtil.noBackButtonCacheControlHeader();
            Response response = new AuthenticationFlowURLHelper(this.session, this.realm, this.uriInfo).showPageExpired(authSession);
            return new AuthorizationEndpointChecks(response);
        }
        UserSessionModel userSessionModel = userSession = authSessionId == null ? null : new UserSessionCrossDCManager(this.session).getUserSessionIfExistsRemotely(this.realm, authSessionId);
        if (userSession != null) {
            logger.debugf("Sent request to authz endpoint. We don't have authentication session with ID '%s' but we have userSession. Will re-create authentication session with same ID", (Object)authSessionId);
            authSession = this.session.authenticationSessions().createAuthenticationSession(authSessionId, this.realm, client);
        } else {
            authSession = manager.createAuthenticationSession(this.realm, client, true);
            logger.debugf("Sent request to authz endpoint. Created new authentication session with ID '%s'", (Object)authSession.getId());
        }
        return new AuthorizationEndpointChecks(authSession);
    }

    protected boolean shouldRestartAuthSession(AuthenticationSessionModel authSession) {
        return this.hasProcessedExecution(authSession);
    }

    private boolean hasProcessedExecution(AuthenticationSessionModel authSession) {
        String lastProcessedExecution = authSession.getAuthNote("last.processed.execution");
        return lastProcessedExecution != null;
    }

    private boolean shouldShowExpirePage(AuthenticationSessionModel authSession) {
        String lastFlow;
        if (this.hasProcessedExecution(authSession)) {
            return true;
        }
        String initialFlow = authSession.getClientNote(APP_INITIATED_FLOW);
        if (initialFlow == null) {
            initialFlow = "authenticate";
        }
        if (!initialFlow.equals(lastFlow = authSession.getAuthNote("current.flow.path")) && CommonClientSessionModel.Action.AUTHENTICATE.toString().equals(authSession.getAction())) {
            logger.debugf("Transition between flows! Current flow: %s, Previous flow: %s", (Object)initialFlow, (Object)lastFlow);
            authSession.setAuthNote("current.flow.path", initialFlow);
            authSession.removeAuthNote("current.authentication.execution");
            return false;
        }
        return false;
    }

    protected abstract boolean isNewRequest(AuthenticationSessionModel var1, ClientModel var2, String var3);

    protected static class AuthorizationEndpointChecks {
        public final AuthenticationSessionModel authSession;
        public final Response response;

        private AuthorizationEndpointChecks(Response response) {
            this.authSession = null;
            this.response = response;
        }

        private AuthorizationEndpointChecks(AuthenticationSessionModel authSession) {
            this.authSession = authSession;
            this.response = null;
        }
    }
}

