/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.admin.cli.commands;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.cl.Option;
import org.jboss.aesh.console.command.CommandException;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.keycloak.client.admin.cli.commands.AbstractAuthOptionsCmd;
import org.keycloak.client.admin.cli.config.ConfigData;
import org.keycloak.client.admin.cli.operations.UserOperations;
import org.keycloak.client.admin.cli.util.AuthUtil;
import org.keycloak.client.admin.cli.util.ConfigUtil;
import org.keycloak.client.admin.cli.util.IoUtil;
import org.keycloak.client.admin.cli.util.OsUtil;

@CommandDefinition(name="set-password", description="[ARGUMENTS]")
public class SetPasswordCmd
extends AbstractAuthOptionsCmd {
    @Option(name="username", description="Username")
    String username;
    @Option(name="userid", description="User ID")
    String userid;
    @Option(shortName=112, name="new-password", description="New password")
    String pass;
    @Option(shortName=116, name="temporary", description="is password temporary", hasValue=false)
    boolean temporary;

    public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
        try {
            if (this.printHelp()) {
                CommandResult commandResult = this.help ? CommandResult.SUCCESS : CommandResult.FAILURE;
                return commandResult;
            }
            this.processGlobalOptions();
            CommandResult commandResult = this.process(commandInvocation);
            return commandResult;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + this.suggestHelp(), e);
        }
        finally {
            commandInvocation.stop();
        }
    }

    public CommandResult process(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
        String adminRoot;
        if (this.args != null && this.args.size() > 0) {
            throw new IllegalArgumentException("Invalid option: " + (String)this.args.get(0));
        }
        if (this.userid == null && this.username == null) {
            throw new IllegalArgumentException("No user specified. Use --username or --userid to specify user");
        }
        if (this.userid != null && this.username != null) {
            throw new IllegalArgumentException("Options --userid and --username are mutually exclusive");
        }
        if (this.pass == null) {
            this.pass = IoUtil.readSecret("Enter password: ", commandInvocation);
        }
        ConfigData config = ConfigUtil.loadConfig();
        config = this.copyWithServerInfo(config);
        this.setupTruststore(config, commandInvocation);
        String auth = null;
        config = this.ensureAuthInfo(config, commandInvocation);
        config = this.copyWithServerInfo(config);
        if (ConfigUtil.credentialsAvailable(config)) {
            auth = AuthUtil.ensureToken(config);
        }
        auth = auth != null ? "Bearer " + auth : null;
        String server = config.getServerUrl();
        String realm = this.getTargetRealm(config);
        String string = adminRoot = this.adminRestRoot != null ? this.adminRestRoot : this.composeAdminRoot(server);
        if (this.username != null) {
            this.userid = UserOperations.getIdFromUsername(adminRoot, realm, auth, this.username);
        }
        UserOperations.resetUserPassword(adminRoot, realm, auth, this.userid, this.pass, this.temporary);
        return CommandResult.SUCCESS;
    }

    @Override
    protected boolean nothingToDo() {
        return this.noOptions() && this.username == null && this.userid == null && this.pass == null;
    }

    protected String suggestHelp() {
        return OsUtil.EOL + "Try '" + OsUtil.CMD + " help set-password' for more information";
    }

    @Override
    protected String help() {
        return SetPasswordCmd.usage();
    }

    public static String usage() {
        StringWriter sb = new StringWriter();
        PrintWriter out = new PrintWriter(sb);
        out.println("Usage: " + OsUtil.CMD + " set-password (--username USERNAME | --userid ID) [--new-password PASSWORD] [ARGUMENTS]");
        out.println();
        out.println("Command to reset user's password.");
        out.println();
        out.println("Use `" + OsUtil.CMD + " config credentials` to establish an authenticated session, or use CREDENTIALS OPTIONS");
        out.println("to perform one time authentication.");
        out.println();
        out.println("Arguments:");
        out.println();
        out.println("  Global options:");
        out.println("    -x                    Print full stack trace when exiting with error");
        out.println("    --config              Path to the config file (" + ConfigUtil.DEFAULT_CONFIG_FILE_STRING + " by default)");
        out.println("    --truststore PATH     Path to a truststore containing trusted certificates");
        out.println("    --trustpass PASSWORD  Truststore password (prompted for if not specified and --truststore is used)");
        out.println("    CREDENTIALS OPTIONS   Same set of options as accepted by '" + OsUtil.CMD + " config credentials' in order to establish");
        out.println("                          an authenticated sessions. This allows on-the-fly transient authentication that does");
        out.println("                          not touch a config file.");
        out.println();
        out.println("  Command specific options:");
        out.println("    --username USERNAME       Identify target user by 'username'");
        out.println("    --userid ID               Identify target user by 'id'");
        out.println("    -p, --new-password        New password to set. If not specified you will be prompted for it.");
        out.println("    -t, --temporary           Make the new password temporary - user has to change it on next logon");
        out.println("    -a, --admin-root URL      URL of Admin REST endpoint root if not default - e.g. http://localhost:8080/auth/admin");
        out.println("    -r, --target-realm REALM  Target realm to issue requests against if not the one authenticated against");
        out.println();
        out.println("Examples:");
        out.println();
        out.println("Set new temporary password for the user:");
        out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " set-password -r demorealm --username testuser --new-password NEWPASS -t");
        out.println();
        out.println();
        out.println("Use '" + OsUtil.CMD + " help' for general information and a list of commands");
        return sb.toString();
    }
}

