/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.process.instance.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.drools.core.WorkItemHandlerNotFoundException;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.process.instance.WorkItem;
import org.drools.core.process.instance.WorkItemManager;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.runtime.Closeable;

public class DefaultWorkItemManager
implements WorkItemManager,
Externalizable {
    private static final long serialVersionUID = 510L;
    private AtomicLong workItemCounter = new AtomicLong(0L);
    private Map<Long, WorkItem> workItems = new ConcurrentHashMap<Long, WorkItem>();
    private InternalKnowledgeRuntime kruntime;
    private Map<String, WorkItemHandler> workItemHandlers = new HashMap<String, WorkItemHandler>();

    public DefaultWorkItemManager(InternalKnowledgeRuntime kruntime) {
        this.kruntime = kruntime;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.workItemCounter.set(in.readLong());
        this.workItems = (Map)in.readObject();
        this.kruntime = (InternalKnowledgeRuntime)in.readObject();
        this.workItemHandlers = (Map)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.workItemCounter.get());
        out.writeObject(this.workItems);
        out.writeObject(this.kruntime);
        out.writeObject(this.workItemHandlers);
    }

    @Override
    public void internalExecuteWorkItem(WorkItem workItem) {
        ((WorkItemImpl)workItem).setId(this.workItemCounter.incrementAndGet());
        this.internalAddWorkItem(workItem);
        WorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
        if (handler == null) {
            throw new WorkItemHandlerNotFoundException("Could not find work item handler for " + workItem.getName(), workItem.getName());
        }
        handler.executeWorkItem((org.kie.api.runtime.process.WorkItem)workItem, (org.kie.api.runtime.process.WorkItemManager)this);
    }

    @Override
    public void internalAddWorkItem(WorkItem workItem) {
        this.workItems.put(workItem.getId(), workItem);
        if (workItem.getId() > this.workItemCounter.get()) {
            this.workItemCounter.set(workItem.getId());
        }
    }

    @Override
    public void internalAbortWorkItem(long id) {
        WorkItemImpl workItem = (WorkItemImpl)this.workItems.get(id);
        if (workItem != null) {
            WorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
            if (handler == null) {
                this.workItems.remove(workItem.getId());
                throw new WorkItemHandlerNotFoundException("Could not find work item handler for " + workItem.getName(), workItem.getName());
            }
            handler.abortWorkItem((org.kie.api.runtime.process.WorkItem)workItem, (org.kie.api.runtime.process.WorkItemManager)this);
            this.workItems.remove(workItem.getId());
        }
    }

    public WorkItemHandler getWorkItemHandler(String name) {
        return this.workItemHandlers.get(name);
    }

    public void retryWorkItem(long workItemId) {
        WorkItem workItem = this.workItems.get(workItemId);
        this.retryWorkItem(workItem);
    }

    public void retryWorkItemWithParams(long workItemId, Map<String, Object> map) {
        WorkItem workItem = this.workItems.get(workItemId);
        if (workItem != null) {
            workItem.setParameters(map);
            this.retryWorkItem(workItem);
        }
    }

    private void retryWorkItem(WorkItem workItem) {
        if (workItem != null) {
            WorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
            if (handler != null) {
                handler.executeWorkItem((org.kie.api.runtime.process.WorkItem)workItem, (org.kie.api.runtime.process.WorkItemManager)this);
            } else {
                throw new WorkItemHandlerNotFoundException("Could not find work item handler for " + workItem.getName(), workItem.getName());
            }
        }
    }

    @Override
    public Set<WorkItem> getWorkItems() {
        return new HashSet<WorkItem>(this.workItems.values());
    }

    @Override
    public WorkItem getWorkItem(long id) {
        return this.workItems.get(id);
    }

    public void completeWorkItem(long id, Map<String, Object> results) {
        WorkItem workItem = this.workItems.get(id);
        if (workItem != null) {
            workItem.setResults(results);
            ProcessInstance processInstance = this.kruntime.getProcessInstance(workItem.getProcessInstanceId());
            workItem.setState(2);
            if (processInstance != null) {
                processInstance.signalEvent("workItemCompleted", (Object)workItem);
            }
            this.workItems.remove(id);
        }
    }

    public void abortWorkItem(long id) {
        WorkItemImpl workItem = (WorkItemImpl)this.workItems.get(id);
        if (workItem != null) {
            ProcessInstance processInstance = this.kruntime.getProcessInstance(workItem.getProcessInstanceId());
            workItem.setState(3);
            if (processInstance != null) {
                processInstance.signalEvent("workItemAborted", (Object)workItem);
            }
            this.workItems.remove(id);
        }
    }

    public void registerWorkItemHandler(String workItemName, WorkItemHandler handler) {
        this.workItemHandlers.put(workItemName, handler);
    }

    @Override
    public void clear() {
        this.workItems.clear();
    }

    @Override
    public void signalEvent(String type, Object event) {
        this.kruntime.signalEvent(type, event);
    }

    @Override
    public void signalEvent(String type, Object event, long processInstanceId) {
        this.kruntime.signalEvent(type, event, processInstanceId);
    }

    @Override
    public void dispose() {
        if (this.workItemHandlers != null) {
            for (Map.Entry<String, WorkItemHandler> handlerEntry : this.workItemHandlers.entrySet()) {
                if (!(handlerEntry.getValue() instanceof Closeable)) continue;
                ((Closeable)handlerEntry.getValue()).close();
            }
        }
    }

    @Override
    public void retryWorkItem(Long workItemID, Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            this.retryWorkItem(workItemID);
        } else {
            this.retryWorkItemWithParams(workItemID, params);
        }
    }
}

