/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.Entry;

public class ObjectHashMap
extends AbstractHashTable
implements Externalizable {
    private static final long serialVersionUID = 510L;

    public ObjectHashMap() {
        this(16, 0.75f);
    }

    public ObjectHashMap(int capacity, float loadFactor) {
        super(capacity, loadFactor);
    }

    public ObjectHashMap(Entry[] table) {
        super(0.75f, table);
    }

    public ObjectHashMap(float loadFactor, Entry[] table) {
        super(loadFactor, table);
    }

    public Object put(Object key, Object value) {
        return this.put(key, value, true);
    }

    public Object put(Object key, Object value, boolean checkExists) {
        int hashCode = this.comparator.hashCodeOf(key);
        int index = ObjectHashMap.indexOf(hashCode, this.table.length);
        if (checkExists) {
            for (ObjectEntry current = (ObjectEntry)this.table[index]; current != null; current = (ObjectEntry)current.getNext()) {
                if (hashCode != current.cachedHashCode || !this.comparator.equal(key, current.key)) continue;
                Object oldValue = current.value;
                current.value = value;
                return oldValue;
            }
        }
        ObjectEntry entry = new ObjectEntry(key, value, hashCode);
        entry.next = this.table[index];
        this.table[index] = entry;
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
        return null;
    }

    public Object get(Object key) {
        int hashCode = this.comparator.hashCodeOf(key);
        int index = ObjectHashMap.indexOf(hashCode, this.table.length);
        for (ObjectEntry current = (ObjectEntry)this.table[index]; current != null; current = (ObjectEntry)current.getNext()) {
            if (hashCode != current.cachedHashCode || !this.comparator.equal(key, current.key)) continue;
            return current.value;
        }
        return null;
    }

    public Object remove(Object key) {
        ObjectEntry previous;
        int hashCode = this.comparator.hashCodeOf(key);
        int index = ObjectHashMap.indexOf(hashCode, this.table.length);
        ObjectEntry current = previous = (ObjectEntry)this.table[index];
        while (current != null) {
            ObjectEntry next = (ObjectEntry)current.getNext();
            if (hashCode == current.cachedHashCode && this.comparator.equal(key, current.key)) {
                if (previous == current) {
                    this.table[index] = next;
                } else {
                    previous.setNext(next);
                }
                current.setNext(null);
                --this.size;
                return current.value;
            }
            previous = current;
            current = next;
        }
        return null;
    }

    public Entry getBucket(Object object) {
        int hashCode = this.comparator.hashCodeOf(object);
        int index = ObjectHashMap.indexOf(hashCode, this.table.length);
        return this.table[index];
    }

    @Override
    public int getResizeHashcode(Entry entry) {
        return ((ObjectEntry)entry).cachedHashCode;
    }

    public static class ObjectEntry
    implements Entry,
    Externalizable {
        private static final long serialVersionUID = 510L;
        private Object key;
        private Object value;
        private int cachedHashCode;
        private Entry next;

        public ObjectEntry() {
        }

        public ObjectEntry(Object key, Object value, int cachedHashCode) {
            this.key = key;
            this.value = value;
            this.cachedHashCode = cachedHashCode;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.key = in.readObject();
            this.value = in.readObject();
            this.cachedHashCode = in.readInt();
            this.next = (Entry)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.key);
            out.writeObject(this.value);
            out.writeInt(this.cachedHashCode);
            out.writeObject(this.next);
        }

        public Object getValue() {
            return this.value;
        }

        public Object getKey() {
            return this.key;
        }

        public Entry getNext() {
            return this.next;
        }

        public void setNext(Entry next) {
            this.next = next;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            ObjectEntry other = (ObjectEntry)object;
            return this.key.equals(other.key) && this.value.equals(other.value);
        }

        public String toString() {
            return "key=" + this.key.toString() + " : value=" + this.value.toString();
        }
    }
}

