/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.credential.hash;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.keycloak.common.util.Base64;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.hash.PasswordHashProvider;
import org.keycloak.models.PasswordPolicy;

public class Pbkdf2PasswordHashProvider
implements PasswordHashProvider {
    private final String providerId;
    private final String pbkdf2Algorithm;
    private final int defaultIterations;
    private final int derivedKeySize;
    public static final int DEFAULT_DERIVED_KEY_SIZE = 512;

    public Pbkdf2PasswordHashProvider(String providerId, String pbkdf2Algorithm, int defaultIterations) {
        this(providerId, pbkdf2Algorithm, defaultIterations, 512);
    }

    public Pbkdf2PasswordHashProvider(String providerId, String pbkdf2Algorithm, int defaultIterations, int derivedKeySize) {
        this.providerId = providerId;
        this.pbkdf2Algorithm = pbkdf2Algorithm;
        this.defaultIterations = defaultIterations;
        this.derivedKeySize = derivedKeySize;
    }

    public boolean policyCheck(PasswordPolicy policy, CredentialModel credential) {
        int policyHashIterations = policy.getHashIterations();
        if (policyHashIterations == -1) {
            policyHashIterations = this.defaultIterations;
        }
        return credential.getHashIterations() == policyHashIterations && this.providerId.equals(credential.getAlgorithm()) && this.derivedKeySize == this.keySize(credential);
    }

    public void encode(String rawPassword, int iterations, CredentialModel credential) {
        if (iterations == -1) {
            iterations = this.defaultIterations;
        }
        byte[] salt = this.getSalt();
        String encodedPassword = this.encode(rawPassword, iterations, salt, this.derivedKeySize);
        credential.setAlgorithm(this.providerId);
        credential.setType("password");
        credential.setSalt(salt);
        credential.setHashIterations(iterations);
        credential.setValue(encodedPassword);
    }

    public String encode(String rawPassword, int iterations) {
        if (iterations == -1) {
            iterations = this.defaultIterations;
        }
        byte[] salt = this.getSalt();
        return this.encode(rawPassword, iterations, salt, this.derivedKeySize);
    }

    public boolean verify(String rawPassword, CredentialModel credential) {
        return this.encode(rawPassword, credential.getHashIterations(), credential.getSalt(), this.keySize(credential)).equals(credential.getValue());
    }

    private int keySize(CredentialModel credential) {
        try {
            byte[] bytes = Base64.decode((String)credential.getValue());
            return bytes.length * 8;
        }
        catch (IOException e) {
            throw new RuntimeException("Credential could not be decoded", e);
        }
    }

    public void close() {
    }

    private String encode(String rawPassword, int iterations, byte[] salt, int derivedKeySize) {
        PBEKeySpec spec = new PBEKeySpec(rawPassword.toCharArray(), salt, iterations, derivedKeySize);
        try {
            byte[] key = this.getSecretKeyFactory().generateSecret(spec).getEncoded();
            return Base64.encodeBytes((byte[])key);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException("Credential could not be encoded", e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] getSalt() {
        byte[] buffer = new byte[16];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(buffer);
        return buffer;
    }

    private SecretKeyFactory getSecretKeyFactory() {
        try {
            return SecretKeyFactory.getInstance(this.pbkdf2Algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("PBKDF2 algorithm not found", e);
        }
    }
}

