/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.broker;

import javax.ws.rs.core.Response;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.AuthenticationFlowException;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.authenticators.broker.util.ExistingUserInfo;
import org.keycloak.authentication.authenticators.broker.util.SerializedBrokeredIdentityContext;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.sessions.AuthenticationSessionModel;

public abstract class AbstractIdpAuthenticator
implements Authenticator {
    public static final String BROKERED_CONTEXT_NOTE = "BROKERED_CONTEXT";
    public static final String EXISTING_USER_INFO = "EXISTING_USER_INFO";
    public static final String UPDATE_PROFILE_EMAIL_CHANGED = "UPDATE_PROFILE_EMAIL_CHANGED";
    public static final String ENFORCE_UPDATE_PROFILE = "ENFORCE_UPDATE_PROFILE";
    public static final String BROKER_REGISTERED_NEW_USER = "BROKER_REGISTERED_NEW_USER";
    public static final String FIRST_BROKER_LOGIN_SUCCESS = "FIRST_BROKER_LOGIN_SUCCESS";

    public void authenticate(AuthenticationFlowContext context) {
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        SerializedBrokeredIdentityContext serializedCtx = SerializedBrokeredIdentityContext.readFromAuthenticationSession(authSession, BROKERED_CONTEXT_NOTE);
        if (serializedCtx == null) {
            throw new AuthenticationFlowException("Not found serialized context in clientSession", AuthenticationFlowError.IDENTITY_PROVIDER_ERROR);
        }
        BrokeredIdentityContext brokerContext = serializedCtx.deserialize(context.getSession(), authSession);
        if (!brokerContext.getIdpConfig().isEnabled()) {
            this.sendFailureChallenge(context, Response.Status.BAD_REQUEST, "identity_provider_error", "identityProviderUnexpectedErrorMessage", AuthenticationFlowError.IDENTITY_PROVIDER_ERROR);
        }
        this.authenticateImpl(context, serializedCtx, brokerContext);
    }

    public void action(AuthenticationFlowContext context) {
        AuthenticationSessionModel clientSession = context.getAuthenticationSession();
        SerializedBrokeredIdentityContext serializedCtx = SerializedBrokeredIdentityContext.readFromAuthenticationSession(clientSession, BROKERED_CONTEXT_NOTE);
        if (serializedCtx == null) {
            throw new AuthenticationFlowException("Not found serialized context in clientSession", AuthenticationFlowError.IDENTITY_PROVIDER_ERROR);
        }
        BrokeredIdentityContext brokerContext = serializedCtx.deserialize(context.getSession(), clientSession);
        if (!brokerContext.getIdpConfig().isEnabled()) {
            this.sendFailureChallenge(context, Response.Status.BAD_REQUEST, "identity_provider_error", "identityProviderUnexpectedErrorMessage", AuthenticationFlowError.IDENTITY_PROVIDER_ERROR);
        }
        this.actionImpl(context, serializedCtx, brokerContext);
    }

    protected abstract void authenticateImpl(AuthenticationFlowContext var1, SerializedBrokeredIdentityContext var2, BrokeredIdentityContext var3);

    protected abstract void actionImpl(AuthenticationFlowContext var1, SerializedBrokeredIdentityContext var2, BrokeredIdentityContext var3);

    protected void sendFailureChallenge(AuthenticationFlowContext context, Response.Status status, String eventError, String errorMessage, AuthenticationFlowError flowError) {
        context.getEvent().user(context.getUser()).error(eventError);
        Response challengeResponse = context.form().setError(errorMessage, new Object[0]).createErrorPage(status);
        context.failureChallenge(flowError, challengeResponse);
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public void close() {
    }

    public static UserModel getExistingUser(KeycloakSession session, RealmModel realm, AuthenticationSessionModel authSession) {
        String existingUserId = authSession.getAuthNote(EXISTING_USER_INFO);
        if (existingUserId == null) {
            throw new AuthenticationFlowException("Unexpected state. There is no existing duplicated user identified in ClientSession", AuthenticationFlowError.INTERNAL_ERROR);
        }
        ExistingUserInfo duplication = ExistingUserInfo.deserialize(existingUserId);
        UserModel existingUser = session.users().getUserById(duplication.getExistingUserId(), realm);
        if (existingUser == null) {
            throw new AuthenticationFlowException("User with ID '" + existingUserId + "' not found.", AuthenticationFlowError.INVALID_USER);
        }
        if (!existingUser.isEnabled()) {
            throw new AuthenticationFlowException("User with ID '" + existingUserId + "', username '" + existingUser.getUsername() + "' disabled.", AuthenticationFlowError.USER_DISABLED);
        }
        return existingUser;
    }
}

