/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.browser;

import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.authenticators.browser.AbstractUsernameFormAuthenticator;
import org.keycloak.credential.CredentialInput;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;

public class OTPFormAuthenticator
extends AbstractUsernameFormAuthenticator
implements Authenticator {
    @Override
    public void action(AuthenticationFlowContext context) {
        this.validateOTP(context);
    }

    public void authenticate(AuthenticationFlowContext context) {
        Response challengeResponse = this.challenge(context, null);
        context.challenge(challengeResponse);
    }

    public void validateOTP(AuthenticationFlowContext context) {
        MultivaluedMap inputData = context.getHttpRequest().getDecodedFormParameters();
        if (inputData.containsKey((Object)"cancel")) {
            context.resetFlow();
            return;
        }
        UserModel userModel = context.getUser();
        if (!this.enabledUser(context, userModel)) {
            return;
        }
        String password = (String)inputData.getFirst((Object)"totp");
        if (password == null) {
            Response challengeResponse = this.challenge(context, null);
            context.challenge(challengeResponse);
            return;
        }
        boolean valid = context.getSession().userCredentialManager().isValid(context.getRealm(), userModel, new CredentialInput[]{UserCredentialModel.otp((String)context.getRealm().getOTPPolicy().getType(), (String)password)});
        if (!valid) {
            context.getEvent().user(userModel).error("invalid_user_credentials");
            Response challengeResponse = this.challenge(context, "invalidTotpMessage");
            context.failureChallenge(AuthenticationFlowError.INVALID_CREDENTIALS, challengeResponse);
            return;
        }
        context.success();
    }

    public boolean requiresUser() {
        return true;
    }

    @Override
    protected String tempDisabledError() {
        return "invalidTotpMessage";
    }

    @Override
    protected Response createLoginForm(LoginFormsProvider form) {
        return form.createLoginTotp();
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return session.userCredentialManager().isConfiguredFor(realm, user, realm.getOTPPolicy().getType());
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
        if (!user.getRequiredActions().contains(UserModel.RequiredAction.CONFIGURE_TOTP.name())) {
            user.addRequiredAction(UserModel.RequiredAction.CONFIGURE_TOTP.name());
        }
    }

    @Override
    public void close() {
    }
}

