/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.gitlab;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.keycloak.broker.oidc.OIDCIdentityProvider;
import org.keycloak.broker.oidc.OIDCIdentityProviderConfig;
import org.keycloak.broker.oidc.mappers.AbstractJsonUserAttributeMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.ErrorResponseException;

public class GitLabIdentityProvider
extends OIDCIdentityProvider
implements SocialIdentityProvider<OIDCIdentityProviderConfig> {
    public static final String AUTH_URL = "https://gitlab.com/oauth/authorize";
    public static final String TOKEN_URL = "https://gitlab.com/oauth/token";
    public static final String USER_INFO = "https://gitlab.com/api/v4/user";
    public static final String API_SCOPE = "api";

    public GitLabIdentityProvider(KeycloakSession session, OIDCIdentityProviderConfig config) {
        super(session, config);
        config.setAuthorizationUrl(AUTH_URL);
        config.setTokenUrl(TOKEN_URL);
        config.setUserInfoUrl(USER_INFO);
        String defaultScope = config.getDefaultScope();
        if (defaultScope.equals("openid")) {
            config.setDefaultScope(("api " + defaultScope).trim());
        }
    }

    @Override
    protected String getUsernameFromUserInfo(JsonNode userInfo) {
        return this.getJsonProperty(userInfo, "username");
    }

    @Override
    protected String getusernameClaimNameForIdToken() {
        return "nickname";
    }

    @Override
    protected boolean supportsExternalExchange() {
        return true;
    }

    @Override
    protected String getProfileEndpointForValidation(EventBuilder event) {
        return this.getUserInfoUrl();
    }

    @Override
    public boolean isIssuer(String issuer, MultivaluedMap<String, String> params) {
        String requestedIssuer = (String)params.getFirst((Object)"subject_issuer");
        if (requestedIssuer == null) {
            requestedIssuer = issuer;
        }
        return requestedIssuer.equals(((OIDCIdentityProviderConfig)this.getConfig()).getAlias());
    }

    @Override
    protected BrokeredIdentityContext exchangeExternalImpl(EventBuilder event, MultivaluedMap<String, String> params) {
        return this.exchangeExternalUserInfoValidationOnly(event, params);
    }

    @Override
    protected BrokeredIdentityContext extractIdentityFromProfile(EventBuilder event, JsonNode profile) {
        String id = this.getJsonProperty(profile, "id");
        if (id == null) {
            event.detail("reason", "id claim is null from user info json");
            event.error("invalid_token");
            throw new ErrorResponseException("invalid_token", "invalid token", Response.Status.BAD_REQUEST);
        }
        return this.gitlabExtractFromProfile(profile);
    }

    private BrokeredIdentityContext gitlabExtractFromProfile(JsonNode profile) {
        String id = this.getJsonProperty(profile, "id");
        BrokeredIdentityContext identity = new BrokeredIdentityContext(id);
        String name = this.getJsonProperty(profile, "name");
        String preferredUsername = this.getJsonProperty(profile, "username");
        String email = this.getJsonProperty(profile, "email");
        AbstractJsonUserAttributeMapper.storeUserProfileForMapper(identity, profile, ((OIDCIdentityProviderConfig)this.getConfig()).getAlias());
        identity.setId(id);
        identity.setName(name);
        identity.setEmail(email);
        identity.setBrokerUserId(((OIDCIdentityProviderConfig)this.getConfig()).getAlias() + "." + id);
        if (preferredUsername == null) {
            preferredUsername = email;
        }
        if (preferredUsername == null) {
            preferredUsername = id;
        }
        identity.setUsername(preferredUsername);
        return identity;
    }

    @Override
    protected BrokeredIdentityContext extractIdentity(AccessTokenResponse tokenResponse, String accessToken, JsonWebToken idToken) throws IOException {
        SimpleHttp.Response response = null;
        int status = 0;
        for (int i = 0; i < 10; ++i) {
            try {
                String userInfoUrl = this.getUserInfoUrl();
                response = SimpleHttp.doGet((String)userInfoUrl, (KeycloakSession)this.session).header("Authorization", "Bearer " + accessToken).asResponse();
                status = response.getStatus();
            }
            catch (IOException e) {
                logger.debug((Object)"Failed to invoke user info for external exchange", (Throwable)e);
            }
            if (status == 200) break;
            response.close();
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (status != 200) {
            logger.debug((Object)("Failed to invoke user info status: " + status));
            throw new IdentityBrokerException("Gitlab user info call failure");
        }
        JsonNode profile = null;
        try {
            profile = response.asJson();
        }
        catch (IOException e) {
            throw new IdentityBrokerException("Gitlab user info call failure");
        }
        String id = this.getJsonProperty(profile, "id");
        if (id == null) {
            throw new IdentityBrokerException("Gitlab id claim is null from user info json");
        }
        BrokeredIdentityContext identity = this.gitlabExtractFromProfile(profile);
        identity.getContextData().put("FEDERATED_ACCESS_TOKEN_RESPONSE", tokenResponse);
        identity.getContextData().put("VALIDATED_ID_TOKEN", idToken);
        this.processAccessTokenResponse(identity, tokenResponse);
        return identity;
    }
}

