/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler.io.memory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.drools.compiler.commons.jci.readers.ResourceReader;
import org.drools.compiler.commons.jci.stores.ResourceStore;
import org.drools.compiler.compiler.io.File;
import org.drools.compiler.compiler.io.FileSystem;
import org.drools.compiler.compiler.io.Folder;
import org.drools.compiler.compiler.io.Path;
import org.drools.compiler.compiler.io.Resource;
import org.drools.compiler.compiler.io.memory.MemoryFile;
import org.drools.compiler.compiler.io.memory.MemoryFolder;
import org.drools.core.util.IoUtils;
import org.drools.core.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryFileSystem
implements FileSystem,
ResourceReader,
Serializable,
ResourceStore {
    private static final Logger log = LoggerFactory.getLogger(MemoryFileSystem.class);
    private final MemoryFolder folder;
    private final Map<String, Set<Resource>> folders = new HashMap<String, Set<Resource>>();
    private final Map<String, Folder> folderMap = new HashMap<String, Folder>();
    private final Map<String, byte[]> fileContents = new HashMap<String, byte[]>();
    private Set<String> modifiedFilesSinceLastMark;

    public MemoryFileSystem() {
        this.folder = new MemoryFolder(this, "");
        this.folders.put("", new HashSet());
    }

    @Override
    public Folder getRootFolder() {
        return this.folder;
    }

    @Override
    public File getFile(Path path) {
        return this.getFile(path.toPortableString());
    }

    @Override
    public Collection<String> getFileNames() {
        return this.fileContents.keySet();
    }

    public Map<String, byte[]> getMap() {
        return this.fileContents;
    }

    @Override
    public File getFile(String path) {
        int lastSlashPos = (path = MemoryFolder.trimLeadingAndTrailing(path)).lastIndexOf(47);
        if (lastSlashPos >= 0) {
            Folder folder = this.getFolder(path.substring(0, lastSlashPos));
            String name = this.decode(path.substring(lastSlashPos + 1));
            return new MemoryFile(this, name, folder);
        }
        Folder folder = this.getRootFolder();
        return new MemoryFile(this, path, folder);
    }

    @Override
    public Folder getFolder(Path path) {
        return this.getFolder(path.toPortableString());
    }

    @Override
    public Folder getFolder(String path) {
        Folder folder = this.folderMap.get(path);
        if (folder == null) {
            folder = new MemoryFolder(this, path);
            this.folderMap.put(path, folder);
        }
        return folder;
    }

    public Set<? extends Resource> getMembers(Folder folder) {
        return this.folders.get(folder.getPath().toPortableString());
    }

    public byte[] getFileContents(MemoryFile file) {
        return this.fileContents.get(file.getPath().toPortableString());
    }

    public void setFileContents(MemoryFile file, byte[] contents) throws IOException {
        byte[] oldContent;
        if (!this.existsFolder((MemoryFolder)file.getFolder())) {
            this.createFolder((MemoryFolder)file.getFolder());
        }
        String fileName = file.getPath().toPortableString();
        if (!(this.modifiedFilesSinceLastMark == null || (oldContent = this.fileContents.get(fileName)) != null && Arrays.equals(oldContent, contents))) {
            this.modifiedFilesSinceLastMark.add(fileName);
        }
        this.fileContents.put(fileName, contents);
        this.folders.get(file.getFolder().getPath().toPortableString()).add(file);
    }

    @Override
    public void mark() {
        this.modifiedFilesSinceLastMark = new HashSet<String>();
    }

    @Override
    public Collection<String> getModifiedResourcesSinceLastMark() {
        return this.modifiedFilesSinceLastMark;
    }

    public boolean existsFolder(MemoryFolder folder) {
        return this.existsFolder(folder.getPath().toPortableString());
    }

    public boolean existsFolder(String path) {
        if (path == null) {
            throw new NullPointerException("Folder path can not be null!");
        }
        return this.folders.get(MemoryFolder.trimLeadingAndTrailing(path)) != null;
    }

    public boolean existsFile(String path) {
        if (path == null) {
            throw new NullPointerException("File path can not be null!");
        }
        return this.fileContents.containsKey(MemoryFolder.trimLeadingAndTrailing(path));
    }

    public void createFolder(MemoryFolder folder) {
        if (!this.existsFolder(folder)) {
            if (!this.existsFolder((MemoryFolder)folder.getParent())) {
                this.createFolder((MemoryFolder)folder.getParent());
            }
            this.folders.put(folder.getPath().toPortableString(), new HashSet());
            Folder parent = folder.getParent();
            this.folders.get(parent.getPath().toPortableString()).add(folder);
        }
    }

    @Override
    public boolean remove(Folder folder) {
        if (folder.exists()) {
            this.remove(this.folders.get(folder.getPath().toPortableString()));
            this.folders.remove(folder.getPath().toPortableString());
            return true;
        }
        return false;
    }

    public void remove(Set<Resource> members) {
        Iterator<Resource> it = members.iterator();
        while (it.hasNext()) {
            Resource res = it.next();
            if (res instanceof Folder) {
                this.remove(this.folders.get(res.getPath().toPortableString()));
            } else {
                String fileName = res.getPath().toPortableString();
                this.fileContents.remove(fileName);
                if (this.modifiedFilesSinceLastMark != null) {
                    this.modifiedFilesSinceLastMark.add(fileName);
                }
            }
            it.remove();
        }
    }

    @Override
    public boolean remove(File file) {
        if (file.exists()) {
            String fileName = file.getPath().toPortableString();
            this.fileContents.remove(fileName);
            if (this.modifiedFilesSinceLastMark != null) {
                this.modifiedFilesSinceLastMark.add(fileName);
            }
            this.folders.get(((MemoryFile)file).getFolder().getPath().toPortableString()).remove(file);
            return true;
        }
        return false;
    }

    public int copyFolder(Folder srcFolder, MemoryFileSystem trgMfs, Folder trgFolder, String ... filters) {
        return MemoryFileSystem.copyFolder(this, srcFolder, trgMfs, trgFolder, 0, filters);
    }

    private static int copyFolder(MemoryFileSystem srcMfs, Folder srcFolder, MemoryFileSystem trgMfs, Folder trgFolder, int count, String ... filters) {
        if (!trgFolder.exists()) {
            trgMfs.getFolder(trgFolder.getPath()).create();
        }
        if (srcFolder != null) {
            for (Resource resource : srcFolder.getMembers()) {
                if (resource instanceof Folder) {
                    count = MemoryFileSystem.copyFolder(srcMfs, (Folder)resource, trgMfs, trgFolder.getFolder(((Folder)resource).getName()), count, filters);
                    continue;
                }
                MemoryFile trgFile = (MemoryFile)trgFolder.getFile(((File)resource).getName());
                boolean accept = false;
                if (filters == null || filters.length == 0) {
                    accept = true;
                } else {
                    for (String filter : filters) {
                        if (!trgFile.getName().endsWith(filter)) continue;
                        accept = true;
                        break;
                    }
                }
                if (!accept) continue;
                try {
                    trgMfs.setFileContents(trgFile, srcMfs.getFileContents((MemoryFile)resource));
                    ++count;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return count;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fileContents == null ? 0 : this.fileContents.hashCode());
        result = 31 * result + (this.folder == null ? 0 : this.folder.hashCode());
        result = 31 * result + (this.folders == null ? 0 : this.folders.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemoryFileSystem other = (MemoryFileSystem)obj;
        if (this.fileContents == null ? other.fileContents != null : !this.fileContents.equals(other.fileContents)) {
            return false;
        }
        if (this.folder == null ? other.folder != null : !this.folder.equals(other.folder)) {
            return false;
        }
        return !(this.folders == null ? other.folders != null : !this.folders.equals(other.folders));
    }

    public String toString() {
        return "MemoryFileSystem [folder=" + this.folder + ", folders=" + this.folders + ", fileContents=" + this.fileContents + "]";
    }

    public void printFs(PrintStream out) {
        this.printFs(this.getRootFolder(), out);
    }

    public void printFs(Folder f, PrintStream out) {
        for (Resource resource : f.getMembers()) {
            out.println(resource);
            if (resource instanceof Folder) {
                this.printFs((Folder)resource, out);
                continue;
            }
            out.println(new String(this.getFileContents((MemoryFile)resource), IoUtils.UTF8_CHARSET));
        }
    }

    @Override
    public boolean isAvailable(String pResourceName) {
        return this.existsFile(pResourceName);
    }

    @Override
    public byte[] getBytes(String pResourceName) {
        return this.getFileContents((MemoryFile)this.getFile(pResourceName));
    }

    @Override
    public void write(String pResourceName, byte[] pResourceData) {
        this.write(pResourceName, pResourceData, false);
    }

    @Override
    public void write(String pResourceName, byte[] pResourceData, boolean createFolder) {
        String folderPath;
        pResourceName = pResourceName.replace(java.io.File.separatorChar, '/');
        if (pResourceData.length == 0 && pResourceName.endsWith("/")) {
            return;
        }
        MemoryFile memoryFile = (MemoryFile)this.getFile(pResourceName);
        if (createFolder && !this.existsFolder(folderPath = memoryFile.getFolder().getPath().toPortableString())) {
            memoryFile.getFolder().create();
        }
        try {
            this.setFileContents(memoryFile, pResourceData);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] read(String pResourceName) {
        return this.getBytes(pResourceName);
    }

    @Override
    public void remove(String pResourceName) {
        this.remove(this.getFile(pResourceName));
    }

    public byte[] writeAsBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.zip(baos);
        return baos.toByteArray();
    }

    public java.io.File writeAsJar(java.io.File folder, String jarName) {
        try {
            java.io.File jarFile = new java.io.File(folder, jarName + ".jar");
            System.out.println(jarFile);
            this.zip(new FileOutputStream(jarFile));
            return jarFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void zip(OutputStream outputStream) {
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(outputStream);
            this.writeJarEntries(this.getRootFolder(), out);
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void writeAsFs(java.io.File file) {
        file.mkdir();
        this.writeAsFs(this.getRootFolder(), file);
    }

    public void writeAsFs(Folder f, java.io.File file1) {
        for (Resource resource : f.getMembers()) {
            if (resource instanceof Folder) {
                java.io.File file2 = new java.io.File(file1, ((Folder)resource).getName());
                file2.mkdir();
                this.writeAsFs((Folder)resource, file2);
                continue;
            }
            byte[] bytes = this.getFileContents((MemoryFile)resource);
            try {
                IoUtils.write((java.io.File)new java.io.File(file1, ((File)resource).getName()), (byte[])bytes);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to write project to file system\n", e);
            }
        }
    }

    private void writeJarEntries(Folder f, ZipOutputStream out) throws IOException {
        for (Resource resource : f.getMembers()) {
            ZipEntry entry;
            String rname = resource.getPath().toPortableString();
            if (resource instanceof Folder) {
                rname = rname.endsWith("/") ? rname : rname + "/";
                entry = new ZipEntry(rname);
                out.putNextEntry(entry);
                this.writeJarEntries((Folder)resource, out);
                continue;
            }
            entry = new ZipEntry(rname);
            out.putNextEntry(entry);
            byte[] contents = this.getFileContents((MemoryFile)resource);
            if (contents == null) {
                IOException e = new IOException("No content found for: " + resource);
                log.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            out.write(contents);
            out.closeEntry();
        }
    }

    public static MemoryFileSystem readFromJar(java.io.File jarFile) {
        MemoryFileSystem mfs = new MemoryFileSystem();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(jarFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                int separator = entry.getName().lastIndexOf(47);
                String path = separator > 0 ? entry.getName().substring(0, separator) : "";
                String name = entry.getName().substring(separator + 1);
                Folder folder = mfs.getFolder(path);
                folder.create();
                File file = folder.getFile(name);
                file.create(zipFile.getInputStream(entry));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return mfs;
    }

    public static MemoryFileSystem readFromJar(byte[] jarFile) {
        return MemoryFileSystem.readFromJar(new ByteArrayInputStream(jarFile));
    }

    public static MemoryFileSystem readFromJar(InputStream jarFile) {
        MemoryFileSystem mfs = new MemoryFileSystem();
        JarInputStream zipFile = null;
        try {
            ZipEntry entry;
            zipFile = new JarInputStream(jarFile);
            while ((entry = zipFile.getNextEntry()) != null) {
                int b;
                ByteArrayOutputStream content = new ByteArrayOutputStream();
                while ((b = zipFile.read()) != -1) {
                    content.write(b);
                }
                mfs.write(entry.getName(), content.toByteArray(), true);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return mfs;
    }

    public String findPomProperties() {
        for (Map.Entry<String, byte[]> content : this.fileContents.entrySet()) {
            if (!content.getKey().endsWith("pom.properties") || !content.getKey().startsWith("META-INF/maven/")) continue;
            ByteArrayInputStream byteArrayIs = new ByteArrayInputStream(content.getValue());
            return StringUtils.readFileAsString((Reader)new InputStreamReader((InputStream)byteArrayIs, IoUtils.UTF8_CHARSET));
        }
        return null;
    }

    public MemoryFileSystem clone() {
        MemoryFileSystem clone = new MemoryFileSystem();
        for (Map.Entry<String, byte[]> entry : this.fileContents.entrySet()) {
            clone.write(entry.getKey(), entry.getValue());
        }
        return clone;
    }

    private String decode(String path) {
        try {
            return URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return path;
        }
    }
}

