/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import java.net.URI;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.Resteasy;
import org.keycloak.locale.LocaleSelectorProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.urls.UrlType;

public class DefaultKeycloakContext
implements KeycloakContext {
    private RealmModel realm;
    private ClientModel client;
    private ClientConnection connection;
    private KeycloakSession session;
    private Map<UrlType, KeycloakUriInfo> uriInfo;
    private AuthenticationSessionModel authenticationSession;

    public DefaultKeycloakContext(KeycloakSession session) {
        this.session = session;
    }

    public URI getAuthServerUrl() {
        return this.getUri(UrlType.FRONTEND).getBaseUri();
    }

    public String getContextPath() {
        return this.getUri(UrlType.FRONTEND).getBaseUri().getPath();
    }

    public KeycloakUriInfo getUri(UrlType type) {
        if (this.uriInfo == null || !this.uriInfo.containsKey(type)) {
            if (this.uriInfo == null) {
                this.uriInfo = new HashMap<UrlType, KeycloakUriInfo>();
            }
            UriInfo originalUriInfo = this.getContextObject(UriInfo.class);
            this.uriInfo.put(type, new KeycloakUriInfo(this.session, type, originalUriInfo));
        }
        return this.uriInfo.get(type);
    }

    public KeycloakUriInfo getUri() {
        return this.getUri(UrlType.FRONTEND);
    }

    public HttpHeaders getRequestHeaders() {
        return this.getContextObject(HttpHeaders.class);
    }

    public <T> T getContextObject(Class<T> clazz) {
        return Resteasy.getContextData(clazz);
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public void setRealm(RealmModel realm) {
        this.realm = realm;
        this.uriInfo = null;
    }

    public ClientModel getClient() {
        return this.client;
    }

    public void setClient(ClientModel client) {
        this.client = client;
    }

    public ClientConnection getConnection() {
        return this.connection;
    }

    public void setConnection(ClientConnection connection) {
        this.connection = connection;
    }

    public Locale resolveLocale(UserModel user) {
        return ((LocaleSelectorProvider)this.session.getProvider(LocaleSelectorProvider.class)).resolveLocale(this.getRealm(), user);
    }

    public AuthenticationSessionModel getAuthenticationSession() {
        return this.authenticationSession;
    }

    public void setAuthenticationSession(AuthenticationSessionModel authenticationSession) {
        this.authenticationSession = authenticationSession;
    }
}

