/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.idm.ComponentTypeRepresentation;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicyFactory;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class ClientRegistrationPolicyResource {
    private final AdminPermissionEvaluator auth;
    private final RealmModel realm;
    private final AdminEventBuilder adminEvent;
    @Context
    protected KeycloakSession session;

    public ClientRegistrationPolicyResource(RealmModel realm, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.auth = auth;
        this.realm = realm;
        this.adminEvent = adminEvent.resource(ResourceType.CLIENT_INITIAL_ACCESS_MODEL);
    }

    @Path(value="providers")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<ComponentTypeRepresentation> getProviders() {
        List providerFactories = this.session.getKeycloakSessionFactory().getProviderFactories(ClientRegistrationPolicy.class);
        return providerFactories.stream().map(factory -> {
            ClientRegistrationPolicyFactory clientRegFactory = (ClientRegistrationPolicyFactory)factory;
            List<ProviderConfigProperty> configProps = clientRegFactory.getConfigProperties(this.session);
            ComponentTypeRepresentation rep = new ComponentTypeRepresentation();
            rep.setId(clientRegFactory.getId());
            rep.setHelpText(clientRegFactory.getHelpText());
            rep.setProperties(ModelToRepresentation.toRepresentation(configProps));
            return rep;
        }).collect(Collectors.toList());
    }
}

