/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import org.jboss.logging.Logger;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.DefaultRequiredActions;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.RealmRepresentation;

public class MigrateTo9_0_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("9.0.0");
    private static final Logger LOG = Logger.getLogger(MigrateTo9_0_0.class);

    @Override
    public ModelVersion getVersion() {
        return VERSION;
    }

    @Override
    public void migrate(KeycloakSession session) {
        session.realms().getRealmsStream().forEach(this::migrateRealmCommon);
    }

    @Override
    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.migrateRealmCommon(realm);
    }

    protected void migrateRealmCommon(RealmModel realm) {
        this.addAccountConsoleClient(realm);
        this.addAccountApiRoles(realm);
        this.enablePkceAdminAccountClients(realm);
        DefaultRequiredActions.addUpdateLocaleAction(realm);
    }

    private void addAccountApiRoles(RealmModel realm) {
        ClientModel accountClient = realm.getClientByClientId("account");
        RoleModel viewAppRole = accountClient.addRole("view-applications");
        viewAppRole.setDescription("${role_view-applications}");
        LOG.debugf("Added the role %s to the '%s' client.", (Object)"view-applications", (Object)"account");
        RoleModel viewConsentRole = accountClient.addRole("view-consent");
        viewConsentRole.setDescription("${role_view-consent}");
        LOG.debugf("Added the role %s to the '%s' client.", (Object)"view-consent", (Object)"account");
        RoleModel manageConsentRole = accountClient.addRole("manage-consent");
        manageConsentRole.setDescription("${role_manage-consent}");
        LOG.debugf("Added the role %s to the '%s' client.", (Object)"manage-consent", (Object)"account");
        manageConsentRole.addCompositeRole(viewConsentRole);
        LOG.debugf("Added the %s role as a composite role to %s", (Object)"view-consent", (Object)"manage-consent");
    }

    protected void addAccountConsoleClient(RealmModel realm) {
        if (realm.getClientByClientId("account-console") == null) {
            ClientModel client = KeycloakModelUtils.createClient(realm, "account-console");
            client.setName("${client_account-console}");
            client.setEnabled(true);
            client.setFullScopeAllowed(false);
            client.setPublicClient(true);
            client.setDirectAccessGrantsEnabled(false);
            client.setRootUrl("${authBaseUrl}");
            String baseUrl = "/realms/" + realm.getName() + "/account/";
            client.setBaseUrl(baseUrl);
            client.addRedirectUri(baseUrl + "*");
            client.setProtocol("openid-connect");
            RoleModel role = realm.getClientByClientId("account").getRole("manage-account");
            if (role != null) {
                client.addScopeMapping(role);
            }
            ProtocolMapperModel audienceMapper = new ProtocolMapperModel();
            audienceMapper.setName("audience resolve");
            audienceMapper.setProtocol("openid-connect");
            audienceMapper.setProtocolMapper("oidc-audience-resolve-mapper");
            client.addProtocolMapper(audienceMapper);
        }
    }

    private void enablePkceAdminAccountClients(RealmModel realm) {
        ClientModel accountConsole;
        ClientModel adminConsole = realm.getClientByClientId("security-admin-console");
        if (adminConsole != null) {
            adminConsole.setAttribute("pkce.code.challenge.method", "S256");
        }
        if ((accountConsole = realm.getClientByClientId("account-console")) != null) {
            accountConsole.setAttribute("pkce.code.challenge.method", "S256");
        }
    }
}

