/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;

public class OAuth2DeviceCodeModel {
    private static final String REALM_ID = "rid";
    private static final String CLIENT_ID = "cid";
    private static final String EXPIRATION_NOTE = "exp";
    private static final String POLLING_INTERVAL_NOTE = "int";
    private static final String NONCE_NOTE = "nonce";
    private static final String SCOPE_NOTE = "scope";
    private static final String USER_SESSION_ID_NOTE = "uid";
    private static final String DENIED_NOTE = "denied";
    private static final String ADDITIONAL_PARAM_PREFIX = "additional_param_";
    private final RealmModel realm;
    private final String clientId;
    private final String deviceCode;
    private final int expiration;
    private final int pollingInterval;
    private final String scope;
    private final String nonce;
    private final String userSessionId;
    private final Boolean denied;
    private final Map<String, String> additionalParams;

    public static OAuth2DeviceCodeModel create(RealmModel realm, ClientModel client, String deviceCode, String scope, String nonce, int expiresIn, int pollingInterval, Map<String, String> additionalParams) {
        int expiration = Time.currentTime() + expiresIn;
        return new OAuth2DeviceCodeModel(realm, client.getClientId(), deviceCode, scope, nonce, expiration, pollingInterval, null, null, additionalParams);
    }

    public OAuth2DeviceCodeModel approve(String userSessionId) {
        return new OAuth2DeviceCodeModel(this.realm, this.clientId, this.deviceCode, this.scope, this.nonce, this.expiration, this.pollingInterval, userSessionId, false, this.additionalParams);
    }

    public OAuth2DeviceCodeModel deny() {
        return new OAuth2DeviceCodeModel(this.realm, this.clientId, this.deviceCode, this.scope, this.nonce, this.expiration, this.pollingInterval, null, true, this.additionalParams);
    }

    private OAuth2DeviceCodeModel(RealmModel realm, String clientId, String deviceCode, String scope, String nonce, int expiration, int pollingInterval, String userSessionId, Boolean denied, Map<String, String> additionalParams) {
        this.realm = realm;
        this.clientId = clientId;
        this.deviceCode = deviceCode;
        this.scope = scope;
        this.nonce = nonce;
        this.expiration = expiration;
        this.pollingInterval = pollingInterval;
        this.userSessionId = userSessionId;
        this.denied = denied;
        this.additionalParams = additionalParams;
    }

    public static OAuth2DeviceCodeModel fromCache(RealmModel realm, String deviceCode, Map<String, String> data) {
        OAuth2DeviceCodeModel model = new OAuth2DeviceCodeModel(realm, deviceCode, data);
        if (!realm.getId().equals(data.get(REALM_ID))) {
            return null;
        }
        return model;
    }

    private OAuth2DeviceCodeModel(RealmModel realm, String deviceCode, Map<String, String> data) {
        this(realm, data.get(CLIENT_ID), deviceCode, data.get(SCOPE_NOTE), data.get(NONCE_NOTE), Integer.parseInt(data.get(EXPIRATION_NOTE)), Integer.parseInt(data.get(POLLING_INTERVAL_NOTE)), data.get(USER_SESSION_ID_NOTE), Boolean.parseBoolean(data.get(DENIED_NOTE)), OAuth2DeviceCodeModel.extractAdditionalParams(data));
    }

    private static Map<String, String> extractAdditionalParams(Map<String, String> data) {
        HashMap<String, String> additionalParams = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : data.entrySet()) {
            if (!entry.getKey().startsWith(ADDITIONAL_PARAM_PREFIX)) continue;
            additionalParams.put(entry.getKey().substring(ADDITIONAL_PARAM_PREFIX.length()), entry.getValue());
        }
        return additionalParams;
    }

    public String getDeviceCode() {
        return this.deviceCode;
    }

    public String getScope() {
        return this.scope;
    }

    public String getNonce() {
        return this.nonce;
    }

    public int getExpiration() {
        return this.expiration;
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    public String getClientId() {
        return this.clientId;
    }

    public boolean isPending() {
        return this.userSessionId == null;
    }

    public boolean isDenied() {
        return this.denied;
    }

    public String getUserSessionId() {
        return this.userSessionId;
    }

    public static String createKey(String deviceCode) {
        return String.format("dc.%s", deviceCode);
    }

    public String serializeKey() {
        return OAuth2DeviceCodeModel.createKey(this.deviceCode);
    }

    public String serializePollingKey() {
        return OAuth2DeviceCodeModel.createKey(this.deviceCode) + ".polling";
    }

    public Map<String, String> toMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(REALM_ID, this.realm.getId());
        if (this.denied == null) {
            result.put(CLIENT_ID, this.clientId);
            result.put(EXPIRATION_NOTE, String.valueOf(this.expiration));
            result.put(POLLING_INTERVAL_NOTE, String.valueOf(this.pollingInterval));
            result.put(SCOPE_NOTE, this.scope);
            result.put(NONCE_NOTE, this.nonce);
        } else if (this.denied.booleanValue()) {
            result.put(EXPIRATION_NOTE, String.valueOf(this.expiration));
            result.put(POLLING_INTERVAL_NOTE, String.valueOf(this.pollingInterval));
            result.put(DENIED_NOTE, String.valueOf(this.denied));
        } else {
            result.put(EXPIRATION_NOTE, String.valueOf(this.expiration));
            result.put(POLLING_INTERVAL_NOTE, String.valueOf(this.pollingInterval));
            result.put(SCOPE_NOTE, this.scope);
            result.put(NONCE_NOTE, this.nonce);
            result.put(USER_SESSION_ID_NOTE, this.userSessionId);
        }
        this.additionalParams.forEach((key, value) -> result.put(ADDITIONAL_PARAM_PREFIX + key, (String)value));
        return result;
    }

    public MultivaluedMap<String, String> getParams() {
        MultivaluedHashMap params = new MultivaluedHashMap();
        params.putSingle((Object)SCOPE_NOTE, (Object)this.scope);
        if (this.nonce != null) {
            params.putSingle((Object)NONCE_NOTE, (Object)this.nonce);
        }
        this.additionalParams.forEach((arg_0, arg_1) -> ((MultivaluedHashMap)params).putSingle(arg_0, arg_1));
        return params;
    }

    public boolean isExpired() {
        return this.getExpiration() - Time.currentTime() < 0;
    }
}

