/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile;

import org.keycloak.userprofile.AttributeContext;
import org.keycloak.userprofile.UserProfileAttributeValidationContext;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.Validator;
import org.keycloak.validate.ValidatorConfig;
import org.keycloak.validate.Validators;

public final class AttributeValidatorMetadata {
    private final String validatorId;
    private final ValidatorConfig validatorConfig;

    public AttributeValidatorMetadata(String validatorId) {
        this.validatorId = validatorId;
        this.validatorConfig = ValidatorConfig.configFromMap(null);
    }

    public AttributeValidatorMetadata(String validatorId, ValidatorConfig validatorConfig) {
        this.validatorId = validatorId;
        this.validatorConfig = validatorConfig;
    }

    public String getValidatorId() {
        return this.validatorId;
    }

    public ValidationContext validate(AttributeContext context) {
        Validator validator = Validators.validator(context.getSession(), this.validatorId);
        if (validator == null) {
            throw new RuntimeException("No validator with id " + this.validatorId + " found to validate UserProfile attribute " + context.getMetadata().getName() + " in realm " + context.getSession().getContext().getRealm().getName());
        }
        return validator.validate(context.getAttribute().getValue(), context.getMetadata().getName(), new UserProfileAttributeValidationContext(context), this.validatorConfig);
    }
}

