/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile;

import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.ws.rs.core.Response;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.theme.Theme;
import org.keycloak.validate.ValidationError;

public final class ValidationException
extends RuntimeException
implements Consumer<ValidationError> {
    private final Map<String, List<Error>> errors = new HashMap<String, List<Error>>();
    private final BiFunction<String, Object[], String> messageFormatter;

    public ValidationException(KeycloakSession session, UserModel user) {
        this.messageFormatter = new MessageFormatter(session, user);
    }

    public List<Error> getErrors() {
        return this.errors.values().stream().reduce(new ArrayList(), (l, r) -> {
            l.addAll(r);
            return l;
        }, (l, r) -> l);
    }

    public boolean hasError(String ... types) {
        if (types.length == 0) {
            return !this.errors.isEmpty();
        }
        for (String type : types) {
            if (!this.errors.containsKey(type)) continue;
            return true;
        }
        return false;
    }

    public boolean isAttributeOnError(String ... name) {
        if (name.length == 0) {
            return !this.errors.isEmpty();
        }
        List<String> names = Arrays.asList(name);
        return this.errors.values().stream().flatMap(Collection::stream).anyMatch(error -> names.contains(error.getAttribute()));
    }

    @Override
    public void accept(ValidationError error) {
        this.addError(error);
    }

    void addError(ValidationError error) {
        List errors = this.errors.computeIfAbsent(error.getMessage(), k -> new ArrayList());
        errors.add(new Error(error, this.messageFormatter));
    }

    @Override
    public String toString() {
        return "ValidationException [errors=" + this.errors + "]";
    }

    @Override
    public String getMessage() {
        return this.toString();
    }

    public Response.Status getStatusCode() {
        for (Map.Entry<String, List<Error>> entry : this.errors.entrySet()) {
            for (Error error : entry.getValue()) {
                if (Response.Status.BAD_REQUEST.equals((Object)error.getStatusCode())) continue;
                return error.getStatusCode();
            }
        }
        return Response.Status.BAD_REQUEST;
    }

    private final class MessageFormatter
    implements BiFunction<String, Object[], String> {
        private final Locale locale;
        private final Properties messages;

        public MessageFormatter(KeycloakSession session, UserModel user) {
            try {
                KeycloakContext context = session.getContext();
                this.locale = context.resolveLocale(user);
                this.messages = this.getTheme(session).getMessages(this.locale);
                RealmModel realm = context.getRealm();
                Map localizationTexts = realm.getRealmLocalizationTextsByLocale(this.locale.toLanguageTag());
                this.messages.putAll((Map<?, ?>)localizationTexts);
            }
            catch (IOException cause) {
                throw new RuntimeException("Failed to configure error messages", cause);
            }
        }

        private Theme getTheme(KeycloakSession session) throws IOException {
            return session.theme().getTheme(Theme.Type.ADMIN);
        }

        @Override
        public String apply(String s, Object[] objects) {
            return new MessageFormat(this.messages.getProperty(s, s), this.locale).format(objects);
        }
    }

    public static class Error
    implements Serializable {
        private final ValidationError error;
        private final BiFunction<String, Object[], String> messageFormatter;

        public Error(ValidationError error, BiFunction<String, Object[], String> messageFormatter) {
            this.error = error;
            this.messageFormatter = messageFormatter;
        }

        public String getAttribute() {
            return this.error.getInputHint();
        }

        public String getMessage() {
            return this.error.getMessage();
        }

        public Object[] getMessageParameters() {
            return this.error.getInputHintWithMessageParameters();
        }

        public String toString() {
            return "Error [error=" + this.error + "]";
        }

        public String getFormattedMessage() {
            return this.messageFormatter.apply(this.getMessage(), this.getMessageParameters());
        }

        public Response.Status getStatusCode() {
            return this.error.getStatusCode();
        }
    }
}

