/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.validate.validators;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ConfiguredProvider;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.validate.AbstractStringValidator;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;
import org.keycloak.validate.ValidationResult;
import org.keycloak.validate.ValidatorConfig;

public class LengthValidator
extends AbstractStringValidator
implements ConfiguredProvider {
    public static final LengthValidator INSTANCE = new LengthValidator();
    public static final String ID = "length";
    public static final String MESSAGE_INVALID_LENGTH = "error-invalid-length";
    public static final String KEY_MIN = "min";
    public static final String KEY_MAX = "max";
    public static final String KEY_TRIM_DISABLED = "trim-disabled";
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    public String getId() {
        return ID;
    }

    @Override
    protected void doValidate(String value, String inputHint, ValidationContext context, ValidatorConfig config) {
        Integer min = config.getInt(KEY_MIN);
        Integer max = config.getInt(KEY_MAX);
        if (!config.getBooleanOrDefault(KEY_TRIM_DISABLED, Boolean.FALSE).booleanValue()) {
            value = value.trim();
        }
        int length = value.length();
        if (config.containsKey(KEY_MIN) && length < min) {
            context.addError(new ValidationError(ID, inputHint, MESSAGE_INVALID_LENGTH, min, max));
            return;
        }
        if (config.containsKey(KEY_MAX) && length > max) {
            context.addError(new ValidationError(ID, inputHint, MESSAGE_INVALID_LENGTH, min, max));
            return;
        }
    }

    @Override
    public ValidationResult validateConfig(KeycloakSession session, ValidatorConfig config) {
        LinkedHashSet<ValidationError> errors = new LinkedHashSet<ValidationError>();
        if (config == null || config == ValidatorConfig.EMPTY) {
            errors.add(new ValidationError(ID, KEY_MIN, "error-validator-config-missing-value"));
            errors.add(new ValidationError(ID, KEY_MAX, "error-validator-config-missing-value"));
        } else {
            if (config.containsKey(KEY_TRIM_DISABLED) && config.getBoolean(KEY_TRIM_DISABLED) == null) {
                errors.add(new ValidationError(ID, KEY_TRIM_DISABLED, "error-validator-config-invalid-boolean-value", config.get(KEY_TRIM_DISABLED)));
            }
            boolean containsMin = config.containsKey(KEY_MIN);
            boolean containsMax = config.containsKey(KEY_MAX);
            if (!containsMin && !containsMax) {
                errors.add(new ValidationError(ID, KEY_MIN, "error-validator-config-missing-value"));
                errors.add(new ValidationError(ID, KEY_MAX, "error-validator-config-missing-value"));
            } else {
                if (containsMin && config.getInt(KEY_MIN) == null) {
                    errors.add(new ValidationError(ID, KEY_MIN, "error-validator-config-invalid-number-value", config.get(KEY_MIN)));
                }
                if (containsMax && config.getInt(KEY_MAX) == null) {
                    errors.add(new ValidationError(ID, KEY_MAX, "error-validator-config-invalid-number-value", config.get(KEY_MAX)));
                }
                if (errors.isEmpty() && containsMin && containsMax && config.getInt(KEY_MIN) > config.getInt(KEY_MAX)) {
                    errors.add(new ValidationError(ID, KEY_MAX, "error-validator-config-invalid-value"));
                }
            }
        }
        return new ValidationResult(errors);
    }

    public String getHelpText() {
        return "Length validator";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(KEY_MIN);
        property.setLabel("Minimum length");
        property.setHelpText("The minimum length");
        property.setType("String");
        configProperties.add(property);
        property = new ProviderConfigProperty();
        property.setName(KEY_MAX);
        property.setLabel("Maximum length");
        property.setHelpText("The maximum length");
        property.setType("String");
        configProperties.add(property);
    }
}

