/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.LDAPConstants;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserFederationEventAwareProviderFactory;
import org.keycloak.models.UserFederationProvider;
import org.keycloak.models.UserFederationProviderFactory;
import org.keycloak.models.UserFederationProviderModel;

public class MigrateTo1_3_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("1.3.0");

    @Override
    public ModelVersion getVersion() {
        return VERSION;
    }

    @Override
    public void migrate(KeycloakSession session) {
        List realms = session.realms().getRealms();
        for (RealmModel realm : realms) {
            this.migrateLDAPProviders(session, realm);
        }
    }

    private void migrateLDAPProviders(KeycloakSession session, RealmModel realm) {
        List federationProviders = realm.getUserFederationProviders();
        for (UserFederationProviderModel fedProvider : federationProviders) {
            UserFederationProviderFactory ldapFactory;
            String usernameLdapAttribute;
            String usersDn;
            if (!fedProvider.getProviderName().equals("ldap")) continue;
            Map config = fedProvider.getConfig();
            if (config.get("searchScope") == null) {
                config.put("searchScope", String.valueOf(2));
            }
            if ((usersDn = (String)config.remove("userDnSuffix")) != null && config.get("usersDn") == null) {
                config.put("usersDn", usersDn);
            }
            if ((usernameLdapAttribute = (String)config.get("usernameLDAPAttribute")) != null && config.get("rdnLDAPAttribute") == null) {
                if (usernameLdapAttribute.equalsIgnoreCase("sAMAccountName")) {
                    config.put("rdnLDAPAttribute", "cn");
                } else {
                    config.put("rdnLDAPAttribute", usernameLdapAttribute);
                }
            }
            if (config.get("uuidLDAPAttribute") == null) {
                String uuidAttrName = LDAPConstants.getUuidAttributeName((String)config.get("vendor"));
                config.put("uuidLDAPAttribute", uuidAttrName);
            }
            realm.updateUserFederationProvider(fedProvider);
            Set mappers = realm.getUserFederationMappersByFederationProvider(fedProvider.getId());
            if (!mappers.isEmpty() || (ldapFactory = (UserFederationProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(UserFederationProvider.class, "ldap")) == null) continue;
            ((UserFederationEventAwareProviderFactory)ldapFactory).onProviderModelCreated(realm, fedProvider);
        }
    }
}

