/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.policy;

import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.hash.PasswordHashProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.policy.HistoryPasswordPolicyProviderFactory;
import org.keycloak.policy.PasswordPolicyProvider;
import org.keycloak.policy.PolicyError;

public class HistoryPasswordPolicyProvider
implements PasswordPolicyProvider {
    private static final Logger logger = Logger.getLogger(HistoryPasswordPolicyProvider.class);
    private static final String ERROR_MESSAGE = "invalidPasswordHistoryMessage";
    private KeycloakSession session;

    public HistoryPasswordPolicyProvider(KeycloakSession session) {
        this.session = session;
    }

    public PolicyError validate(String username, String password) {
        return null;
    }

    public PolicyError validate(RealmModel realm, UserModel user, String password) {
        PasswordPolicy policy = this.session.getContext().getRealm().getPasswordPolicy();
        int passwordHistoryPolicyValue = (Integer)policy.getPolicyConfig("passwordHistory");
        if (passwordHistoryPolicyValue != -1) {
            List storedPasswords = this.session.userCredentialManager().getStoredCredentialsByType(realm, user, "password");
            for (CredentialModel cred : storedPasswords) {
                PasswordHashProvider hash = (PasswordHashProvider)this.session.getProvider(PasswordHashProvider.class, cred.getAlgorithm());
                if (hash == null || !hash.verify(password, cred)) continue;
                return new PolicyError(ERROR_MESSAGE, new Object[]{passwordHistoryPolicyValue});
            }
            List passwordHistory = this.session.userCredentialManager().getStoredCredentialsByType(realm, user, "password-history");
            for (CredentialModel cred : passwordHistory) {
                PasswordHashProvider hash = (PasswordHashProvider)this.session.getProvider(PasswordHashProvider.class, cred.getAlgorithm());
                if (!hash.verify(password, cred)) continue;
                return new PolicyError(ERROR_MESSAGE, new Object[]{passwordHistoryPolicyValue});
            }
        }
        return null;
    }

    public Object parseConfig(String value) {
        return value != null ? Integer.parseInt(value) : HistoryPasswordPolicyProviderFactory.DEFAULT_VALUE;
    }

    public void close() {
    }
}

