/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.component.ComponentFactory;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.idm.ComponentRepresentation;

public class ComponentUtil {
    public static Map<String, ProviderConfigProperty> getComponentConfigProperties(KeycloakSession session, ComponentRepresentation component) {
        return ComponentUtil.getComponentConfigProperties(session, component.getProviderType(), component.getProviderId());
    }

    public static Map<String, ProviderConfigProperty> getComponentConfigProperties(KeycloakSession session, ComponentModel component) {
        return ComponentUtil.getComponentConfigProperties(session, component.getProviderType(), component.getProviderId());
    }

    public static ComponentFactory getComponentFactory(KeycloakSession session, ComponentRepresentation component) {
        return ComponentUtil.getComponentFactory(session, component.getProviderType(), component.getProviderId());
    }

    public static ComponentFactory getComponentFactory(KeycloakSession session, ComponentModel component) {
        return ComponentUtil.getComponentFactory(session, component.getProviderType(), component.getProviderId());
    }

    private static Map<String, ProviderConfigProperty> getComponentConfigProperties(KeycloakSession session, String providerType, String providerId) {
        try {
            ComponentFactory componentFactory = ComponentUtil.getComponentFactory(session, providerType, providerId);
            List l = componentFactory.getConfigProperties();
            HashMap<String, ProviderConfigProperty> properties = new HashMap<String, ProviderConfigProperty>();
            for (ProviderConfigProperty p : l) {
                properties.put(p.getName(), p);
            }
            List common = componentFactory.getCommonProviderConfigProperties();
            for (ProviderConfigProperty p : common) {
                properties.put(p.getName(), p);
            }
            return properties;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static ComponentFactory getComponentFactory(KeycloakSession session, String providerType, String providerId) {
        Class provider = session.getProviderClass(providerType);
        if (provider == null) {
            throw new IllegalArgumentException("Invalid provider type '" + providerType + "'");
        }
        ProviderFactory f = session.getKeycloakSessionFactory().getProviderFactory(provider, providerId);
        if (f == null) {
            throw new IllegalArgumentException("No such provider '" + providerId + "'");
        }
        ComponentFactory cf = (ComponentFactory)f;
        return cf;
    }

    public static void notifyCreated(KeycloakSession session, RealmModel realm, ComponentModel model) {
        ComponentFactory factory = ComponentUtil.getComponentFactory(session, model);
        factory.onCreate(session, realm, model);
    }

    public static void notifyUpdated(KeycloakSession session, RealmModel realm, ComponentModel model) {
        ComponentFactory factory = ComponentUtil.getComponentFactory(session, model);
        factory.onUpdate(session, realm, model);
    }
}

