/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.utils;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class ProxyClassLoader
extends ClassLoader {
    private Set<ClassLoader> classloaders;

    public ProxyClassLoader(ClassLoader ... delegateClassLoaders) {
        if (delegateClassLoaders == null || delegateClassLoaders.length == 0) {
            throw new IllegalStateException("At least one classloader to delegate must be provided");
        }
        this.classloaders = new LinkedHashSet<ClassLoader>();
        this.classloaders.addAll(Arrays.asList(delegateClassLoaders));
    }

    public ProxyClassLoader(Collection<Class<?>> classes) {
        this.init(classes);
    }

    private void init(Collection<Class<?>> classes) {
        this.classloaders = new LinkedHashSet<ClassLoader>();
        for (Class<?> clazz : classes) {
            this.classloaders.add(clazz.getClassLoader());
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        for (ClassLoader classloader : this.classloaders) {
            try {
                return classloader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return super.loadClass(name);
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader classloader : this.classloaders) {
            URL resource = classloader.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        final LinkedHashSet<URL> resourceUrls = new LinkedHashSet<URL>();
        for (ClassLoader classloader : this.classloaders) {
            Enumeration<URL> child = classloader.getResources(name);
            while (child.hasMoreElements()) {
                resourceUrls.add(child.nextElement());
            }
        }
        return new Enumeration<URL>(){
            final Iterator<URL> resourceUrlIterator;
            {
                this.resourceUrlIterator = resourceUrls.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.resourceUrlIterator.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.resourceUrlIterator.next();
            }
        };
    }

    public String toString() {
        return "ProxyClassLoader: Delegates: " + this.classloaders;
    }
}

