/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.LinkedHashMap;
import java.util.Map;

public class ContentSecurityPolicyBuilder {
    public static final String DIRECTIVE_NAME_FRAME_SRC = "frame-src";
    public static final String DIRECTIVE_NAME_FRAME_ANCESTORS = "frame-ancestors";
    public static final String DIRECTIVE_NAME_OBJECT_SRC = "object-src";
    public static final String DIRECTIVE_VALUE_SELF = "'self'";
    public static final String DIRECTIVE_VALUE_NONE = "'none'";
    private final Map<String, String> directives = new LinkedHashMap<String, String>();

    public static ContentSecurityPolicyBuilder create() {
        return new ContentSecurityPolicyBuilder().add(DIRECTIVE_NAME_FRAME_SRC, DIRECTIVE_VALUE_SELF).add(DIRECTIVE_NAME_FRAME_ANCESTORS, DIRECTIVE_VALUE_SELF).add(DIRECTIVE_NAME_OBJECT_SRC, DIRECTIVE_VALUE_NONE);
    }

    public static ContentSecurityPolicyBuilder create(String directives) {
        return new ContentSecurityPolicyBuilder().parse(directives);
    }

    public ContentSecurityPolicyBuilder frameSrc(String frameSrc) {
        if (frameSrc == null) {
            this.directives.remove(DIRECTIVE_NAME_FRAME_SRC);
        } else {
            this.put(DIRECTIVE_NAME_FRAME_SRC, frameSrc);
        }
        return this;
    }

    public ContentSecurityPolicyBuilder addFrameSrc(String frameSrc) {
        return this.add(DIRECTIVE_NAME_FRAME_SRC, frameSrc);
    }

    public boolean isDefaultFrameAncestors() {
        return DIRECTIVE_VALUE_SELF.equals(this.directives.get(DIRECTIVE_NAME_FRAME_ANCESTORS));
    }

    public ContentSecurityPolicyBuilder frameAncestors(String frameancestors) {
        if (frameancestors == null) {
            this.directives.remove(DIRECTIVE_NAME_FRAME_ANCESTORS);
        } else {
            this.put(DIRECTIVE_NAME_FRAME_ANCESTORS, frameancestors);
        }
        return this;
    }

    public ContentSecurityPolicyBuilder addFrameAncestors(String frameancestors) {
        return this.add(DIRECTIVE_NAME_FRAME_ANCESTORS, frameancestors);
    }

    public String build() {
        StringBuilder sb = new StringBuilder();
        if (!this.directives.isEmpty()) {
            for (Map.Entry<String, String> entry : this.directives.entrySet()) {
                sb.append(entry.getKey());
                if (!entry.getValue().isEmpty()) {
                    sb.append(" ").append(entry.getValue());
                }
                sb.append("; ");
            }
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private ContentSecurityPolicyBuilder put(String name, String value) {
        if (name != null && value != null) {
            this.directives.put(name, value);
        }
        return this;
    }

    private ContentSecurityPolicyBuilder add(String name, String value) {
        if (name != null && value != null) {
            String current = this.directives.get(name);
            if (current != null && !current.isEmpty()) {
                value = current + " " + value;
            }
            this.directives.put(name, value);
        }
        return this;
    }

    private ContentSecurityPolicyBuilder parse(String value) {
        if (value == null) {
            return this;
        }
        String[] values = value.split(";");
        if (values != null) {
            for (String directive : values) {
                int idx = (directive = directive.trim()).indexOf(32);
                if (idx > 0) {
                    this.add(directive.substring(0, idx), directive.substring(idx + 1, directive.length()).trim());
                    continue;
                }
                if (directive.isEmpty()) continue;
                this.add(directive, "");
            }
        }
        return this;
    }
}

