/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.provider.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.keycloak.connections.httpclient.HttpClientProvider;
import org.keycloak.models.KeycloakSession;

public class SimpleHttp {
    private KeycloakSession session;
    private String url;
    private String method;
    private Map<String, String> headers;
    private Map<String, String> params;

    protected SimpleHttp(String url, String method, KeycloakSession session) {
        this.session = session;
        this.url = url;
        this.method = method;
    }

    public static SimpleHttp doGet(String url, KeycloakSession session) {
        return new SimpleHttp(url, "GET", session);
    }

    public static SimpleHttp doPost(String url, KeycloakSession session) {
        return new SimpleHttp(url, "POST", session);
    }

    public SimpleHttp header(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(name, value);
        return this;
    }

    public SimpleHttp param(String name, String value) {
        if (this.params == null) {
            this.params = new HashMap<String, String>();
        }
        this.params.put(name, value);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String asString() throws IOException {
        HttpClient httpClient = ((HttpClientProvider)this.session.getProvider(HttpClientProvider.class)).getHttpClient();
        HttpResponse response = this.makeRequest(httpClient);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            try (InputStream is = entity.getContent();){
                HeaderIterator it = response.headerIterator();
                while (it.hasNext()) {
                    Header header = it.nextHeader();
                    if (!header.getName().equals("Content-Encoding") || !header.getValue().equals("gzip")) continue;
                    is = new GZIPInputStream(is);
                }
                String string = this.toString(is);
                return string;
            }
        }
        return null;
    }

    public int asStatus() throws IOException {
        HttpClient httpClient = ((HttpClientProvider)this.session.getProvider(HttpClientProvider.class)).getHttpClient();
        HttpResponse response = this.makeRequest(httpClient);
        return response.getStatusLine().getStatusCode();
    }

    private HttpResponse makeRequest(HttpClient httpClient) throws IOException {
        boolean get = this.method.equals("GET");
        boolean post = this.method.equals("POST");
        HttpPost httpRequest = new HttpPost(this.url);
        if (get) {
            httpRequest = new HttpGet(this.appendParameterToUrl(this.url));
        }
        if (post) {
            httpRequest.setEntity((HttpEntity)this.getFormEntityFromParameter());
        }
        if (this.headers != null) {
            for (Map.Entry<String, String> h : this.headers.entrySet()) {
                httpRequest.setHeader(h.getKey(), h.getValue());
            }
        }
        return httpClient.execute((HttpUriRequest)httpRequest);
    }

    private URI appendParameterToUrl(String url) throws IOException {
        URI uri = null;
        try {
            URIBuilder uriBuilder = new URIBuilder(url);
            if (this.params != null) {
                for (Map.Entry<String, String> p : this.params.entrySet()) {
                    uriBuilder.setParameter(p.getKey(), p.getValue());
                }
            }
            uri = uriBuilder.build();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return uri;
    }

    private UrlEncodedFormEntity getFormEntityFromParameter() throws IOException {
        ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
        if (this.params != null) {
            for (Map.Entry<String, String> p : this.params.entrySet()) {
                urlParameters.add(new BasicNameValuePair(p.getKey(), p.getValue()));
            }
        }
        return new UrlEncodedFormEntity(urlParameters);
    }

    private String toString(InputStream is) throws IOException {
        InputStreamReader reader = new InputStreamReader(is);
        StringWriter writer = new StringWriter();
        char[] buffer = new char[4096];
        int n = reader.read(buffer);
        while (n != -1) {
            writer.write(buffer, 0, n);
            n = reader.read(buffer);
        }
        return writer.toString();
    }
}

