/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.evaluation;

import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.Evaluation;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.representations.idm.authorization.Logic;

public class DefaultEvaluation
implements Evaluation {
    private final ResourcePermission permission;
    private final EvaluationContext executionContext;
    private final Decision decision;
    private final Policy policy;
    private final Policy parentPolicy;
    private final AuthorizationProvider authorizationProvider;
    private Decision.Effect effect;

    public DefaultEvaluation(ResourcePermission permission, EvaluationContext executionContext, Policy parentPolicy, Policy policy, Decision decision, AuthorizationProvider authorizationProvider) {
        this.permission = permission;
        this.executionContext = executionContext;
        this.parentPolicy = parentPolicy;
        this.policy = policy;
        this.decision = decision;
        this.authorizationProvider = authorizationProvider;
    }

    @Override
    public ResourcePermission getPermission() {
        return this.permission;
    }

    @Override
    public EvaluationContext getContext() {
        return this.executionContext;
    }

    @Override
    public void grant() {
        this.effect = this.policy != null && Logic.NEGATIVE.equals((Object)this.policy.getLogic()) ? Decision.Effect.DENY : Decision.Effect.PERMIT;
        this.decision.onDecision(this);
    }

    @Override
    public void deny() {
        this.effect = this.policy != null && Logic.NEGATIVE.equals((Object)this.policy.getLogic()) ? Decision.Effect.PERMIT : Decision.Effect.DENY;
        this.decision.onDecision(this);
    }

    @Override
    public Policy getPolicy() {
        return this.policy;
    }

    @Override
    public AuthorizationProvider getAuthorizationProvider() {
        return this.authorizationProvider;
    }

    public Policy getParentPolicy() {
        return this.parentPolicy;
    }

    public Decision.Effect getEffect() {
        return this.effect;
    }

    void denyIfNoEffect() {
        if (this.effect == null) {
            this.deny();
        }
    }
}

