/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.evaluation;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.DefaultEvaluation;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.authorization.policy.evaluation.PolicyEvaluator;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.representations.idm.authorization.PolicyEnforcementMode;

public class DefaultPolicyEvaluator
implements PolicyEvaluator {
    private final AuthorizationProvider authorization;
    private final StoreFactory storeFactory;
    private final PolicyStore policyStore;
    private final ResourceStore resourceStore;

    public DefaultPolicyEvaluator(AuthorizationProvider authorization) {
        this.authorization = authorization;
        this.storeFactory = this.authorization.getStoreFactory();
        this.policyStore = this.storeFactory.getPolicyStore();
        this.resourceStore = this.storeFactory.getResourceStore();
    }

    @Override
    public void evaluate(ResourcePermission permission, EvaluationContext executionContext, Decision decision) {
        ResourceServer resourceServer = permission.getResourceServer();
        PolicyEnforcementMode enforcementMode = resourceServer.getPolicyEnforcementMode();
        if (PolicyEnforcementMode.DISABLED.equals((Object)enforcementMode)) {
            this.createEvaluation(permission, executionContext, decision, null, null).grant();
            return;
        }
        AtomicBoolean verified = new AtomicBoolean(false);
        Consumer<Policy> consumer = this.createDecisionConsumer(permission, executionContext, decision, verified);
        Resource resource = permission.getResource();
        List<Scope> scopes = permission.getScopes();
        if (resource != null) {
            this.evaluatePolicies(() -> this.policyStore.findByResource(resource.getId(), resourceServer.getId()), consumer);
            if (resource.getType() != null) {
                this.evaluatePolicies(() -> this.policyStore.findByResourceType(resource.getType(), resourceServer.getId()), consumer);
            }
            if (scopes.isEmpty() && !resource.getScopes().isEmpty()) {
                scopes.removeAll(resource.getScopes());
                this.evaluatePolicies(() -> this.policyStore.findByScopeIds(resource.getScopes().stream().map(Scope::getId).collect(Collectors.toList()), resourceServer.getId()), consumer);
            }
        }
        if (!scopes.isEmpty()) {
            this.evaluatePolicies(() -> this.policyStore.findByScopeIds(scopes.stream().map(Scope::getId).collect(Collectors.toList()), resourceServer.getId()), consumer);
        }
        if (PolicyEnforcementMode.PERMISSIVE.equals((Object)enforcementMode) && !verified.get()) {
            this.createEvaluation(permission, executionContext, decision, null, null).grant();
        }
    }

    private void evaluatePolicies(Supplier<List<Policy>> supplier, Consumer<Policy> consumer) {
        List<Policy> policies = supplier.get();
        if (!policies.isEmpty()) {
            policies.forEach(consumer);
        }
    }

    private Consumer<Policy> createDecisionConsumer(ResourcePermission permission, EvaluationContext executionContext, Decision decision, AtomicBoolean verified) {
        return parentPolicy -> {
            if (!this.hasRequestedScopes(permission, (Policy)parentPolicy)) {
                return;
            }
            for (Policy associatedPolicy : parentPolicy.getAssociatedPolicies()) {
                Object policyProvider = this.authorization.getProvider(associatedPolicy.getType());
                if (policyProvider == null) {
                    throw new RuntimeException("Unknown parentPolicy provider for type [" + associatedPolicy.getType() + "].");
                }
                DefaultEvaluation evaluation = this.createEvaluation(permission, executionContext, decision, (Policy)parentPolicy, associatedPolicy);
                policyProvider.evaluate(evaluation);
                evaluation.denyIfNoEffect();
            }
            verified.compareAndSet(false, true);
        };
    }

    private DefaultEvaluation createEvaluation(ResourcePermission permission, EvaluationContext executionContext, Decision decision, Policy parentPolicy, Policy associatedPolicy) {
        return new DefaultEvaluation(permission, executionContext, parentPolicy, associatedPolicy, decision, this.authorization);
    }

    private boolean hasRequestedScopes(ResourcePermission permission, Policy policy) {
        if (permission.getScopes().isEmpty()) {
            return true;
        }
        Resource resourcePermission = permission.getResource();
        Set<Resource> policyResources = policy.getResources();
        if (resourcePermission != null && !policyResources.isEmpty() && !policyResources.stream().filter(resource -> resource.getId().equals(resourcePermission.getId())).findFirst().isPresent()) {
            return false;
        }
        HashSet<Scope> scopes = new HashSet<Scope>(policy.getScopes());
        if (scopes.isEmpty()) {
            Object resource2;
            String type;
            HashSet<Resource> resources = new HashSet<Resource>();
            resources.addAll(policyResources);
            for (Resource resource3 : resources) {
                scopes.addAll(resource3.getScopes());
            }
            if (!resources.isEmpty() && scopes.isEmpty()) {
                return false;
            }
            if (scopes.isEmpty() && (type = (resource2 = permission.getResource()).getType()) != null) {
                List<Resource> resourcesByType = this.resourceStore.findByType(type, resource2.getResourceServer().getId());
                for (Resource resourceType : resourcesByType) {
                    if (!resourceType.getOwner().equals(resource2.getResourceServer().getClientId())) continue;
                    resources.add(resourceType);
                }
            }
            for (Resource resource3 : resources) {
                scopes.addAll(resource3.getScopes());
            }
        }
        for (Scope givenScope : scopes) {
            for (Scope scope : permission.getScopes()) {
                if (!givenScope.getId().equals(scope.getId())) continue;
                return true;
            }
        }
        return false;
    }
}

