/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.DefaultAuthenticationFlows;

public class MigrateTo3_2_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("3.2.0");

    @Override
    public void migrate(KeycloakSession session) {
        for (RealmModel realm : session.realms().getRealms()) {
            ClientModel masterAdminClient;
            ClientModel realmAccess;
            PasswordPolicy.Builder builder = realm.getPasswordPolicy().toBuilder();
            if (!builder.contains("hashAlgorithm") && "20000".equals(builder.get("hashIterations"))) {
                realm.setPasswordPolicy(builder.remove("hashIterations").build(session));
            }
            if (realm.getDockerAuthenticationFlow() == null) {
                DefaultAuthenticationFlows.dockerAuthenticationFlow(realm);
            }
            if ((realmAccess = realm.getClientByClientId("realm-management")) != null) {
                this.addRoles(realmAccess);
            }
            if ((masterAdminClient = realm.getMasterAdminClient()) == null) continue;
            this.addRoles(masterAdminClient);
        }
    }

    public void addRoles(ClientModel realmAccess) {
        RoleModel viewUsers;
        RoleModel queryClients = realmAccess.addRole(AdminRoles.QUERY_CLIENTS);
        RoleModel queryUsers = realmAccess.addRole(AdminRoles.QUERY_USERS);
        RoleModel queryGroups = realmAccess.addRole(AdminRoles.QUERY_GROUPS);
        RoleModel viewClients = realmAccess.getRole(AdminRoles.VIEW_CLIENTS);
        if (viewClients != null) {
            viewClients.addCompositeRole(queryClients);
        }
        if ((viewUsers = realmAccess.getRole(AdminRoles.VIEW_USERS)) != null) {
            viewUsers.addCompositeRole(queryUsers);
            viewUsers.addCompositeRole(queryGroups);
        }
    }

    @Override
    public ModelVersion getVersion() {
        return VERSION;
    }
}

