/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.jboss.logging.Logger;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.Config;
import org.keycloak.common.util.SystemEnvProperties;
import org.keycloak.exportimport.ExportImportManager;
import org.keycloak.migration.MigrationModelManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.PostMigrationEvent;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.DefaultKeycloakSessionFactory;
import org.keycloak.services.managers.ApplianceBootstrap;
import org.keycloak.services.managers.BruteForceProtector;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.UsersSyncManager;
import org.keycloak.services.resources.JsResource;
import org.keycloak.services.resources.ModelExceptionMapper;
import org.keycloak.services.resources.QRCodeResource;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.resources.ServerVersionResource;
import org.keycloak.services.resources.ThemeResource;
import org.keycloak.services.resources.WelcomeResource;
import org.keycloak.services.resources.admin.AdminRoot;
import org.keycloak.services.scheduled.ClearExpiredEvents;
import org.keycloak.services.scheduled.ClearExpiredUserSessions;
import org.keycloak.services.scheduled.ScheduledTaskRunner;
import org.keycloak.services.util.JsonConfigProvider;
import org.keycloak.services.util.ObjectMapperResolver;
import org.keycloak.timer.TimerProvider;
import org.keycloak.util.JsonSerialization;

public class KeycloakApplication
extends Application {
    private static final Logger log = Logger.getLogger(KeycloakApplication.class);
    protected Set<Object> singletons = new HashSet<Object>();
    protected Set<Class<?>> classes = new HashSet();
    protected KeycloakSessionFactory sessionFactory;
    protected String contextPath;

    public KeycloakApplication(@Context ServletContext context, @Context Dispatcher dispatcher) {
        KeycloakApplication.loadConfig();
        this.contextPath = context.getContextPath();
        this.sessionFactory = KeycloakApplication.createSessionFactory();
        dispatcher.getDefaultContextObjects().put(KeycloakApplication.class, this);
        BruteForceProtector protector = new BruteForceProtector(this.sessionFactory);
        dispatcher.getDefaultContextObjects().put(BruteForceProtector.class, protector);
        ResteasyProviderFactory.pushContext(BruteForceProtector.class, (Object)protector);
        ResteasyProviderFactory.pushContext(KeycloakApplication.class, (Object)((Object)this));
        protector.start();
        context.setAttribute(BruteForceProtector.class.getName(), (Object)protector);
        context.setAttribute(KeycloakSessionFactory.class.getName(), (Object)this.sessionFactory);
        this.singletons.add(new ServerVersionResource());
        this.singletons.add(new RealmsResource());
        this.singletons.add(new AdminRoot());
        this.singletons.add(new ModelExceptionMapper());
        this.classes.add(QRCodeResource.class);
        this.classes.add(ThemeResource.class);
        this.classes.add(JsResource.class);
        this.classes.add(WelcomeResource.class);
        this.singletons.add(new ObjectMapperResolver(Boolean.parseBoolean(System.getProperty("keycloak.jsonPrettyPrint", "false"))));
        boolean defaultRealmCreated = ApplianceBootstrap.setupDefaultRealm(this.sessionFactory, context.getContextPath());
        this.migrateModel();
        this.sessionFactory.publish((ProviderEvent)new PostMigrationEvent());
        new ExportImportManager().checkExportImport(this.sessionFactory, context.getContextPath());
        this.importRealms(context);
        this.importAddUser();
        if (defaultRealmCreated) {
            ApplianceBootstrap.setupDefaultUser(this.sessionFactory);
        }
        KeycloakApplication.setupScheduledTasks(this.sessionFactory);
    }

    protected void migrateModel() {
        try (KeycloakSession session = this.sessionFactory.create();){
            session.getTransaction().begin();
            MigrationModelManager.migrate((KeycloakSession)session);
            session.getTransaction().commit();
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public URI getBaseUri(UriInfo uriInfo) {
        return uriInfo.getBaseUriBuilder().replacePath(this.getContextPath()).build(new Object[0]);
    }

    public static void loadConfig() {
        try {
            URL resource;
            File f;
            JsonNode node = null;
            String configDir = System.getProperty("jboss.server.config.dir");
            if (configDir != null && (f = new File(configDir + File.separator + "keycloak-server.json")).isFile()) {
                log.info((Object)("Load config from " + f.getAbsolutePath()));
                node = new ObjectMapper().readTree(f);
            }
            if (node == null && (resource = Thread.currentThread().getContextClassLoader().getResource("META-INF/keycloak-server.json")) != null) {
                log.info((Object)("Load config from " + resource));
                node = new ObjectMapper().readTree(resource);
            }
            if (node != null) {
                SystemEnvProperties properties = new SystemEnvProperties();
                Config.init((Config.ConfigProvider)new JsonConfigProvider(node, (Properties)properties));
                return;
            }
            throw new RuntimeException("Config 'keycloak-server.json' not found");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load config", e);
        }
    }

    public static KeycloakSessionFactory createSessionFactory() {
        DefaultKeycloakSessionFactory factory = new DefaultKeycloakSessionFactory();
        factory.init();
        return factory;
    }

    public static void setupScheduledTasks(KeycloakSessionFactory sessionFactory) {
        long interval = Config.scope((String[])new String[]{"scheduled"}).getLong("interval", Long.valueOf(60L)) * 1000L;
        TimerProvider timer = (TimerProvider)sessionFactory.create().getProvider(TimerProvider.class);
        timer.schedule((Runnable)new ScheduledTaskRunner(sessionFactory, new ClearExpiredEvents()), interval, "ClearExpiredEvents");
        timer.schedule((Runnable)new ScheduledTaskRunner(sessionFactory, new ClearExpiredUserSessions()), interval, "ClearExpiredUserSessions");
        new UsersSyncManager().bootstrapPeriodic(sessionFactory, timer);
    }

    public KeycloakSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }

    public void importRealms(ServletContext context) {
        this.importRealmFile();
        this.importRealmResources(context);
    }

    public void importRealmResources(ServletContext context) {
        String resources = context.getInitParameter("keycloak.import.realm.resources");
        if (resources != null) {
            StringTokenizer tokenizer = new StringTokenizer(resources, ",");
            while (tokenizer.hasMoreTokens()) {
                String resource = tokenizer.nextToken().trim();
                InputStream is = context.getResourceAsStream(resource);
                if (is == null) {
                    log.warn((Object)("Could not find realm resource to import: " + resource));
                }
                RealmRepresentation rep = KeycloakApplication.loadJson(is, RealmRepresentation.class);
                this.importRealm(rep, "resource " + resource);
            }
        }
    }

    public void importRealmFile() {
        String files = System.getProperty("keycloak.import");
        if (files != null) {
            StringTokenizer tokenizer = new StringTokenizer(files, ",");
            while (tokenizer.hasMoreTokens()) {
                String file = tokenizer.nextToken().trim();
                RealmRepresentation rep = null;
                try {
                    rep = KeycloakApplication.loadJson(new FileInputStream(file), RealmRepresentation.class);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
                this.importRealm(rep, "file " + file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importRealm(RealmRepresentation rep, String from) {
        try (KeycloakSession session = this.sessionFactory.create();){
            session.getTransaction().begin();
            RealmManager manager = new RealmManager(session);
            manager.setContextPath(this.getContextPath());
            if (rep.getId() != null && manager.getRealm(rep.getId()) != null) {
                log.info((Object)("Not importing realm " + rep.getRealm() + " from " + from + ".  It already exists."));
                return;
            }
            if (manager.getRealmByName(rep.getRealm()) != null) {
                log.info((Object)("Not importing realm " + rep.getRealm() + " from " + from + ".  It already exists."));
                return;
            }
            try {
                RealmModel realm = manager.importRealm(rep);
                session.getTransaction().commit();
                log.info((Object)("Imported realm " + realm.getName() + " from " + from));
            }
            catch (Throwable t) {
                session.getTransaction().rollback();
                log.warn((Object)("Unable to import realm " + rep.getRealm() + " from " + from + ". Cause: " + t.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importAddUser() {
        File addUserFile;
        String configDir = System.getProperty("jboss.server.config.dir");
        if (configDir != null && (addUserFile = new File(configDir + File.separator + "keycloak-add-user.json")).isFile()) {
            List realms;
            log.info((Object)("Importing users from '" + addUserFile + "'"));
            try {
                realms = (List)JsonSerialization.readValue((InputStream)new FileInputStream(addUserFile), (TypeReference)new TypeReference<List<RealmRepresentation>>(){});
            }
            catch (IOException e) {
                log.errorv("Failed to load 'keycloak-add-user.json': {0}", (Object)e.getMessage());
                return;
            }
            for (RealmRepresentation realmRep : realms) {
                for (UserRepresentation userRep : realmRep.getUsers()) {
                    try (KeycloakSession session = this.sessionFactory.create();){
                        session.getTransaction().begin();
                        RealmModel realm = session.realms().getRealmByName(realmRep.getRealm());
                        if (realm == null) {
                            log.errorv("Failed to add user ''{0}'' to realm ''{1}'': realm not found", (Object)userRep.getUsername(), (Object)realmRep.getRealm());
                        } else {
                            UserModel user = session.users().addUser(realm, userRep.getUsername());
                            user.setEnabled(userRep.isEnabled().booleanValue());
                            RepresentationToModel.createCredentials((UserRepresentation)userRep, (UserModel)user);
                            RepresentationToModel.createRoleMappings((UserRepresentation)userRep, (UserModel)user, (RealmModel)realm);
                        }
                        session.getTransaction().commit();
                        log.infov("Added user ''{0}'' to realm ''{1}''", (Object)userRep.getUsername(), (Object)realmRep.getRealm());
                    }
                }
            }
            if (!addUserFile.delete()) {
                log.errorv("Failed to delete '{0}'", (Object)addUserFile.getAbsolutePath());
            }
        }
    }

    private static <T> T loadJson(InputStream is, Class<T> type) {
        try {
            return (T)JsonSerialization.readValue((InputStream)is, type);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse json", e);
        }
    }
}

