/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.partialimport;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.partialimport.ClientsPartialImport;
import org.keycloak.partialimport.ErrorResponseException;
import org.keycloak.partialimport.GroupsPartialImport;
import org.keycloak.partialimport.IdentityProvidersPartialImport;
import org.keycloak.partialimport.PartialImport;
import org.keycloak.partialimport.PartialImportResult;
import org.keycloak.partialimport.PartialImportResults;
import org.keycloak.partialimport.RolesPartialImport;
import org.keycloak.partialimport.UsersPartialImport;
import org.keycloak.representations.idm.PartialImportRepresentation;
import org.keycloak.services.resources.admin.AdminEventBuilder;

public class PartialImportManager {
    private final List<PartialImport> partialImports = new ArrayList<PartialImport>();
    private final PartialImportRepresentation rep;
    private final KeycloakSession session;
    private final RealmModel realm;
    private final AdminEventBuilder adminEvent;

    public PartialImportManager(PartialImportRepresentation rep, KeycloakSession session, RealmModel realm, AdminEventBuilder adminEvent) {
        this.rep = rep;
        this.session = session;
        this.realm = realm;
        this.adminEvent = adminEvent;
        this.partialImports.add(new ClientsPartialImport());
        this.partialImports.add(new RolesPartialImport());
        this.partialImports.add(new IdentityProvidersPartialImport());
        this.partialImports.add(new GroupsPartialImport());
        this.partialImports.add(new UsersPartialImport());
    }

    public Response saveResources() {
        PartialImportResults results = new PartialImportResults();
        for (PartialImport partialImport : this.partialImports) {
            try {
                partialImport.prepare(this.rep, this.realm, this.session);
            }
            catch (ErrorResponseException error) {
                if (this.session.getTransaction().isActive()) {
                    this.session.getTransaction().setRollbackOnly();
                }
                return error.getResponse();
            }
        }
        for (PartialImport partialImport : this.partialImports) {
            try {
                partialImport.removeOverwrites(this.realm, this.session);
                results.addAllResults(partialImport.doImport(this.rep, this.realm, this.session));
            }
            catch (ErrorResponseException error) {
                if (this.session.getTransaction().isActive()) {
                    this.session.getTransaction().setRollbackOnly();
                }
                return error.getResponse();
            }
        }
        for (PartialImportResult result : results.getResults()) {
            switch (result.getAction()) {
                case ADDED: {
                    this.fireCreatedEvent(result);
                    break;
                }
                case OVERWRITTEN: {
                    this.fireUpdateEvent(result);
                }
            }
        }
        if (this.session.getTransaction().isActive()) {
            this.session.getTransaction().commit();
        }
        return Response.ok((Object)results).build();
    }

    private void fireCreatedEvent(PartialImportResult result) {
        this.adminEvent.operation(OperationType.CREATE).resourcePath(result.getResourceType().getPath(), result.getId()).representation(result.getRepresentation()).success();
    }

    private void fireUpdateEvent(PartialImportResult result) {
        this.adminEvent.operation(OperationType.UPDATE).resourcePath(result.getResourceType().getPath(), result.getId()).representation(result.getRepresentation()).success();
    }
}

