/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import java.io.IOException;
import org.keycloak.Config;
import org.keycloak.exportimport.ClientDescriptionConverter;
import org.keycloak.exportimport.ClientDescriptionConverterFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.oidc.OIDCClientRepresentation;
import org.keycloak.services.clientregistration.oidc.DescriptionConverter;
import org.keycloak.util.JsonSerialization;

public class OIDCClientDescriptionConverter
implements ClientDescriptionConverter,
ClientDescriptionConverterFactory {
    public static final String ID = "openid-connect";

    @Override
    public boolean isSupported(String description) {
        return (description = description.trim()).startsWith("{") && description.endsWith("}") && description.contains("\"redirect_uris\"");
    }

    @Override
    public ClientRepresentation convertToInternal(String description) {
        try {
            OIDCClientRepresentation clientOIDC = (OIDCClientRepresentation)JsonSerialization.readValue((String)description, OIDCClientRepresentation.class);
            return DescriptionConverter.toInternal(clientOIDC);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ClientDescriptionConverter create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return ID;
    }
}

