/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.ScopeContainerModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.ClientMappingsRepresentation;
import org.keycloak.representations.idm.MappingsRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.ScopeMappedClientResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class ScopeMappedResource {
    protected RealmModel realm;
    protected AdminPermissionEvaluator auth;
    protected AdminPermissionEvaluator.RequirePermissionCheck managePermission;
    protected AdminPermissionEvaluator.RequirePermissionCheck viewPermission;
    protected ScopeContainerModel scopeContainer;
    protected KeycloakSession session;
    protected AdminEventBuilder adminEvent;

    public ScopeMappedResource(RealmModel realm, AdminPermissionEvaluator auth, ScopeContainerModel scopeContainer, KeycloakSession session, AdminEventBuilder adminEvent, AdminPermissionEvaluator.RequirePermissionCheck managePermission, AdminPermissionEvaluator.RequirePermissionCheck viewPermission) {
        this.realm = realm;
        this.auth = auth;
        this.scopeContainer = scopeContainer;
        this.session = session;
        this.adminEvent = adminEvent.resource(ResourceType.REALM_SCOPE_MAPPING);
        this.managePermission = managePermission;
        this.viewPermission = viewPermission;
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    public MappingsRepresentation getScopeMappings() {
        List clients;
        this.viewPermission.require();
        if (this.scopeContainer == null) {
            throw new NotFoundException("Could not find client");
        }
        MappingsRepresentation all = new MappingsRepresentation();
        Set realmMappings = this.scopeContainer.getRealmScopeMappings();
        if (realmMappings.size() > 0) {
            ArrayList<RoleRepresentation> realmRep = new ArrayList<RoleRepresentation>();
            for (RoleModel roleModel : realmMappings) {
                realmRep.add(ModelToRepresentation.toBriefRepresentation((RoleModel)roleModel));
            }
            all.setRealmMappings(realmRep);
        }
        if ((clients = this.realm.getClients()).size() > 0) {
            HashMap<String, ClientMappingsRepresentation> clientMappings = new HashMap<String, ClientMappingsRepresentation>();
            for (ClientModel client : clients) {
                Set roleMappings = KeycloakModelUtils.getClientScopeMappings((ClientModel)client, (ScopeContainerModel)this.scopeContainer);
                if (roleMappings.size() <= 0) continue;
                ClientMappingsRepresentation mappings = new ClientMappingsRepresentation();
                mappings.setId(client.getId());
                mappings.setClient(client.getClientId());
                ArrayList<RoleRepresentation> roles = new ArrayList<RoleRepresentation>();
                mappings.setMappings(roles);
                for (RoleModel role : roleMappings) {
                    roles.add(ModelToRepresentation.toBriefRepresentation((RoleModel)role));
                }
                clientMappings.put(client.getClientId(), mappings);
                all.setClientMappings(clientMappings);
            }
        }
        return all;
    }

    @Path(value="realm")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getRealmScopeMappings() {
        this.viewPermission.require();
        if (this.scopeContainer == null) {
            throw new NotFoundException("Could not find client");
        }
        Set realmMappings = this.scopeContainer.getRealmScopeMappings();
        ArrayList<RoleRepresentation> realmMappingsRep = new ArrayList<RoleRepresentation>();
        for (RoleModel roleModel : realmMappings) {
            realmMappingsRep.add(ModelToRepresentation.toBriefRepresentation((RoleModel)roleModel));
        }
        return realmMappingsRep;
    }

    @Path(value="realm/available")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getAvailableRealmScopeMappings() {
        this.viewPermission.require();
        if (this.scopeContainer == null) {
            throw new NotFoundException("Could not find client");
        }
        Set roles = this.realm.getRoles();
        return ScopeMappedResource.getAvailable(this.auth, this.scopeContainer, roles);
    }

    public static List<RoleRepresentation> getAvailable(AdminPermissionEvaluator auth, ScopeContainerModel client, Set<RoleModel> roles) {
        ArrayList<RoleRepresentation> available = new ArrayList<RoleRepresentation>();
        for (RoleModel roleModel : roles) {
            if (client.hasScope(roleModel) || !auth.roles().canMapClientScope(roleModel)) continue;
            available.add(ModelToRepresentation.toBriefRepresentation((RoleModel)roleModel));
        }
        return available;
    }

    @Path(value="realm/composite")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getCompositeRealmScopeMappings() {
        this.viewPermission.require();
        if (this.scopeContainer == null) {
            throw new NotFoundException("Could not find client");
        }
        Set roles = this.realm.getRoles();
        return ScopeMappedResource.getComposite(this.scopeContainer, roles);
    }

    public static List<RoleRepresentation> getComposite(ScopeContainerModel client, Set<RoleModel> roles) {
        ArrayList<RoleRepresentation> composite = new ArrayList<RoleRepresentation>();
        for (RoleModel roleModel : roles) {
            if (!client.hasScope(roleModel)) continue;
            composite.add(ModelToRepresentation.toBriefRepresentation((RoleModel)roleModel));
        }
        return composite;
    }

    @Path(value="realm")
    @POST
    @Consumes(value={"application/json"})
    public void addRealmScopeMappings(List<RoleRepresentation> roles) {
        this.managePermission.require();
        if (this.scopeContainer == null) {
            throw new NotFoundException("Could not find client");
        }
        for (RoleRepresentation role : roles) {
            RoleModel roleModel = this.realm.getRoleById(role.getId());
            if (roleModel == null) {
                throw new NotFoundException("Role not found");
            }
            this.scopeContainer.addScopeMapping(roleModel);
        }
        this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(roles).success();
    }

    @Path(value="realm")
    @DELETE
    @Consumes(value={"application/json"})
    public void deleteRealmScopeMappings(List<RoleRepresentation> roles) {
        this.managePermission.require();
        if (this.scopeContainer == null) {
            throw new NotFoundException("Could not find client");
        }
        if (roles == null) {
            Set roleModels = this.scopeContainer.getRealmScopeMappings();
            roles = new LinkedList<RoleRepresentation>();
            for (RoleModel roleModel : roleModels) {
                this.scopeContainer.deleteScopeMapping(roleModel);
                roles.add(ModelToRepresentation.toBriefRepresentation((RoleModel)roleModel));
            }
        } else {
            for (RoleRepresentation role : roles) {
                RoleModel roleModel = this.realm.getRoleById(role.getId());
                if (roleModel == null) {
                    throw new NotFoundException("Client not found");
                }
                this.scopeContainer.deleteScopeMapping(roleModel);
            }
        }
        this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(roles).success();
    }

    @Path(value="clients/{client}")
    public ScopeMappedClientResource getClientByIdScopeMappings(@PathParam(value="client") String client) {
        ClientModel clientModel = this.realm.getClientById(client);
        if (clientModel == null) {
            throw new NotFoundException("Could not find client");
        }
        return new ScopeMappedClientResource(this.realm, this.auth, this.scopeContainer, this.session, clientModel, this.adminEvent, this.managePermission, this.viewPermission);
    }
}

