/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.saml.mappers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.broker.provider.AbstractIdentityProviderMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderSyncMode;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.utils.RegexUtils;

public class AdvancedAttributeToRoleMapper
extends AbstractIdentityProviderMapper {
    public static final String PROVIDER_ID = "saml-advanced-role-idp-mapper";
    public static final String ATTRIBUTE_PROPERTY_NAME = "attributes";
    public static final String ARE_ATTRIBUTE_VALUES_REGEX_PROPERTY_NAME = "are.attribute.values.regex";
    private static final Set<IdentityProviderSyncMode> IDENTITY_PROVIDER_SYNC_MODES = new HashSet<IdentityProviderSyncMode>(Arrays.asList(IdentityProviderSyncMode.values()));
    public static final String[] COMPATIBLE_PROVIDERS = new String[]{"saml"};
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    public boolean supportsSyncMode(IdentityProviderSyncMode syncMode) {
        return IDENTITY_PROVIDER_SYNC_MODES.contains(syncMode);
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String[] getCompatibleProviders() {
        return COMPATIBLE_PROVIDERS;
    }

    public String getDisplayCategory() {
        return "Role Importer";
    }

    public String getDisplayType() {
        return "Advanced Attribute to Role";
    }

    public void importNewUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        String roleName = (String)mapperModel.getConfig().get("role");
        RoleModel role = AdvancedAttributeToRoleMapper.getRoleModel(realm, roleName);
        if (this.hasAllValues(mapperModel, context)) {
            user.grantRole(role);
        }
    }

    public void updateBrokeredUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        String roleName = (String)mapperModel.getConfig().get("role");
        RoleModel role = AdvancedAttributeToRoleMapper.getRoleModel(realm, roleName);
        if (this.hasAllValues(mapperModel, context)) {
            user.grantRole(role);
        } else {
            user.deleteRoleMapping(role);
        }
    }

    public String getHelpText() {
        return "If the set of attributes exists and can be matched, grant the user the specified realm or application role.";
    }

    static RoleModel getRoleModel(RealmModel realm, String roleName) {
        RoleModel role = KeycloakModelUtils.getRoleFromString((RealmModel)realm, (String)roleName);
        if (role == null) {
            throw new IdentityBrokerException("Unable to find role: " + roleName);
        }
        return role;
    }

    boolean hasAllValues(IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        Map attributes = mapperModel.getConfigMap(ATTRIBUTE_PROPERTY_NAME);
        boolean areAttributeValuesRegexes = Boolean.parseBoolean((String)mapperModel.getConfig().get(ARE_ATTRIBUTE_VALUES_REGEX_PROPERTY_NAME));
        AssertionType assertion = (AssertionType)context.getContextData().get("SAML_ASSERTION");
        Set attributeAssertions = assertion.getAttributeStatements();
        if (attributeAssertions == null) {
            return false;
        }
        for (Map.Entry attribute : attributes.entrySet()) {
            String attributeKey = (String)attribute.getKey();
            List attributeValues = attributeAssertions.stream().flatMap(statements -> statements.getAttributes().stream()).filter(choiceType -> attributeKey.equals(choiceType.getAttribute().getName()) || attributeKey.equals(choiceType.getAttribute().getFriendlyName())).flatMap(choiceType -> choiceType.getAttribute().getAttributeValue().stream()).collect(Collectors.toList());
            boolean attributeValueMatch = areAttributeValuesRegexes ? RegexUtils.valueMatchesRegex((String)attribute.getValue(), attributeValues) : attributeValues.contains(attribute.getValue());
            if (attributeValueMatch) continue;
            return false;
        }
        return true;
    }

    static {
        ProviderConfigProperty attributeMappingProperty = new ProviderConfigProperty();
        attributeMappingProperty.setName(ATTRIBUTE_PROPERTY_NAME);
        attributeMappingProperty.setLabel("Attributes");
        attributeMappingProperty.setHelpText("Name and (regex) value of the attributes to search for in token.  The configured name of an attribute is searched in SAML attribute name and attribute friendly name fields. Every given attribute description must be met to set the role. If the attribute is an array, then the value must be contained in the array. If an attribute can be found several times, then one match is sufficient.");
        attributeMappingProperty.setType("Map");
        configProperties.add(attributeMappingProperty);
        ProviderConfigProperty isAttributeRegexProperty = new ProviderConfigProperty();
        isAttributeRegexProperty.setName(ARE_ATTRIBUTE_VALUES_REGEX_PROPERTY_NAME);
        isAttributeRegexProperty.setLabel("Regex Attribute Values");
        isAttributeRegexProperty.setHelpText("If enabled attribute values are interpreted as regular expressions.");
        isAttributeRegexProperty.setType("boolean");
        configProperties.add(isAttributeRegexProperty);
        ProviderConfigProperty roleProperty = new ProviderConfigProperty();
        roleProperty.setName("role");
        roleProperty.setLabel("Role");
        roleProperty.setHelpText("Role to grant to user if all attributes are present. Click 'Select Role' button to browse roles, or just type it in the textbox. To reference an application role the syntax is appname.approle, i.e. myapp.myrole");
        roleProperty.setType("Role");
        configProperties.add(roleProperty);
    }
}

