/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.security.Key;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.PemUtils;
import org.keycloak.dom.saml.v2.SAML2Object;
import org.keycloak.dom.saml.v2.protocol.ExtensionsType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.dom.saml.v2.protocol.StatusResponseType;
import org.keycloak.models.ClientModel;
import org.keycloak.protocol.saml.SamlClient;
import org.keycloak.rotation.HardcodedKeyLocator;
import org.keycloak.rotation.KeyLocator;
import org.keycloak.saml.SignatureAlgorithm;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.processing.api.saml.v2.sig.SAML2Signature;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.saml.processing.core.util.KeycloakKeySamlExtensionGenerator;
import org.keycloak.saml.processing.web.util.RedirectBindingUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SamlProtocolUtils {
    public static void verifyDocumentSignature(ClientModel client, Document document) throws VerificationException {
        PublicKey publicKey = SamlProtocolUtils.getSignatureValidationKey(client);
        SamlProtocolUtils.verifyDocumentSignature(document, (KeyLocator)new HardcodedKeyLocator((Key)publicKey));
    }

    public static void verifyDocumentSignature(Document document, KeyLocator keyLocator) throws VerificationException {
        SAML2Signature saml2Signature = new SAML2Signature();
        try {
            if (!saml2Signature.validate(document, keyLocator)) {
                throw new VerificationException("Invalid signature on document");
            }
        }
        catch (ProcessingException e) {
            throw new VerificationException("Error validating signature", (Throwable)e);
        }
    }

    public static PublicKey getSignatureValidationKey(ClientModel client) throws VerificationException {
        return SamlProtocolUtils.getPublicKey(new SamlClient(client).getClientSigningCertificate());
    }

    public static PublicKey getEncryptionKey(ClientModel client) throws VerificationException {
        return SamlProtocolUtils.getPublicKey(client, "saml.encryption.certificate");
    }

    public static PublicKey getPublicKey(ClientModel client, String attribute) throws VerificationException {
        String certPem = client.getAttribute(attribute);
        return SamlProtocolUtils.getPublicKey(certPem);
    }

    private static PublicKey getPublicKey(String certPem) throws VerificationException {
        if (certPem == null) {
            throw new VerificationException("Client does not have a public key.");
        }
        X509Certificate cert = null;
        try {
            cert = PemUtils.decodeCertificate((String)certPem);
            cert.checkValidity();
        }
        catch (CertificateException ex) {
            throw new VerificationException("Certificate is not valid.");
        }
        catch (Exception e) {
            throw new VerificationException("Could not decode cert", (Throwable)e);
        }
        return cert.getPublicKey();
    }

    public static void verifyRedirectSignature(SAMLDocumentHolder documentHolder, KeyLocator locator, UriInfo uriInformation, String paramKey) throws VerificationException {
        MultivaluedMap encodedParams = uriInformation.getQueryParameters(false);
        SamlProtocolUtils.verifyRedirectSignature(documentHolder, locator, (MultivaluedMap<String, String>)encodedParams, paramKey);
    }

    public static void verifyRedirectSignature(SAMLDocumentHolder documentHolder, KeyLocator locator, MultivaluedMap<String, String> encodedParams, String paramKey) throws VerificationException {
        String request = (String)encodedParams.getFirst((Object)paramKey);
        String algorithm = (String)encodedParams.getFirst((Object)"SigAlg");
        String signature = (String)encodedParams.getFirst((Object)"Signature");
        String relayState = (String)encodedParams.getFirst((Object)"RelayState");
        if (request == null) {
            throw new VerificationException("SAM was null");
        }
        if (algorithm == null) {
            throw new VerificationException("SigAlg was null");
        }
        if (signature == null) {
            throw new VerificationException("Signature was null");
        }
        String keyId = SamlProtocolUtils.getMessageSigningKeyId(documentHolder.getSamlObject());
        StringBuilder rawQueryBuilder = new StringBuilder().append(paramKey).append("=").append(request);
        if (encodedParams.containsKey((Object)"RelayState")) {
            rawQueryBuilder.append("&RelayState=").append(relayState);
        }
        rawQueryBuilder.append("&SigAlg=").append(algorithm);
        String rawQuery = rawQueryBuilder.toString();
        try {
            byte[] decodedSignature = RedirectBindingUtil.urlBase64Decode((String)signature);
            String decodedAlgorithm = RedirectBindingUtil.urlDecode((String)((String)encodedParams.getFirst((Object)"SigAlg")));
            SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.getFromXmlMethod((String)decodedAlgorithm);
            Signature validator = signatureAlgorithm.createSignature();
            Key key = locator.getKey(keyId);
            if (!(key instanceof PublicKey)) {
                throw new VerificationException("Invalid key locator for signature verification");
            }
            validator.initVerify((PublicKey)key);
            validator.update(rawQuery.getBytes("UTF-8"));
            if (!validator.verify(decodedSignature)) {
                throw new VerificationException("Invalid query param signature");
            }
        }
        catch (Exception e) {
            throw new VerificationException((Throwable)e);
        }
    }

    private static String getMessageSigningKeyId(SAML2Object doc) {
        ExtensionsType extensions;
        if (doc instanceof RequestAbstractType) {
            extensions = ((RequestAbstractType)doc).getExtensions();
        } else if (doc instanceof StatusResponseType) {
            extensions = ((StatusResponseType)doc).getExtensions();
        } else {
            return null;
        }
        if (extensions == null) {
            return null;
        }
        for (Object ext : extensions.getAny()) {
            String res;
            if (!(ext instanceof Element) || (res = KeycloakKeySamlExtensionGenerator.getMessageSigningKeyIdFromElement((Element)((Element)ext))) == null) continue;
            return res;
        }
        return null;
    }
}

