/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.account;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonObjectBuilder;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.common.Version;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.Auth;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.util.ResolveRelative;
import org.keycloak.services.validation.Validation;
import org.keycloak.theme.FreeMarkerException;
import org.keycloak.theme.FreeMarkerUtil;
import org.keycloak.theme.Theme;
import org.keycloak.theme.beans.MessageFormatterMethod;
import org.keycloak.urls.UrlType;

public class AccountConsole {
    private static final Logger logger = Logger.getLogger(AccountConsole.class);
    private final Pattern bundleParamPattern = Pattern.compile("(\\{\\s*(\\d+)\\s*\\})");
    @Context
    protected KeycloakSession session;
    private final AppAuthManager authManager;
    private final RealmModel realm;
    private final ClientModel client;
    private final Theme theme;
    private Auth auth;

    public AccountConsole(RealmModel realm, ClientModel client, Theme theme) {
        this.realm = realm;
        this.client = client;
        this.theme = theme;
        this.authManager = new AppAuthManager();
    }

    public void init() {
        AuthenticationManager.AuthResult authResult = this.authManager.authenticateIdentityCookie(this.session, this.realm);
        if (authResult != null) {
            this.auth = new Auth(this.realm, authResult.getToken(), authResult.getUser(), this.client, authResult.getSession(), true);
        }
    }

    @GET
    @NoCache
    public Response getMainPage() throws IOException, FreeMarkerException {
        if (!this.session.getContext().getUri().getRequestUri().getPath().endsWith("/")) {
            return Response.status((int)302).location(this.session.getContext().getUri().getRequestUriBuilder().path("/").build(new Object[0])).build();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        KeycloakUriInfo uriInfo = this.session.getContext().getUri(UrlType.FRONTEND);
        URI authUrl = uriInfo.getBaseUri();
        map.put("authUrl", authUrl.toString());
        map.put("baseUrl", uriInfo.getBaseUriBuilder().path(RealmsResource.class).path(this.realm.getName()).path("account").build(new Object[]{this.realm}).toString());
        map.put("realm", this.realm);
        map.put("resourceUrl", Urls.themeRoot(authUrl).getPath() + "/" + "account" + "/" + this.theme.getName());
        map.put("resourceVersion", Version.RESOURCES_VERSION);
        String[] referrer = this.getReferrer();
        if (referrer != null) {
            map.put("referrer", referrer[0]);
            map.put("referrerName", referrer[1]);
            map.put("referrer_uri", referrer[2]);
        }
        UserModel user = null;
        if (this.auth != null) {
            user = this.auth.getUser();
        }
        Locale locale = this.session.getContext().resolveLocale(user);
        map.put("locale", locale.toLanguageTag());
        Properties messages = this.theme.getMessages(locale);
        map.put("msg", new MessageFormatterMethod(locale, messages));
        map.put("msgJSON", this.messagesToJsonString(messages));
        map.put("supportedLocales", this.supportedLocales(messages));
        map.put("properties", this.theme.getProperties());
        map.put("theme", file -> {
            try {
                InputStream resource = this.theme.getResourceAsStream(file);
                return new Scanner(resource, "UTF-8").useDelimiter("\\A").next();
            }
            catch (IOException e) {
                throw new RuntimeException("could not load file", e);
            }
        });
        EventStoreProvider eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
        map.put("isEventsEnabled", eventStore != null && this.realm.isEventsEnabled());
        map.put("isAuthorizationEnabled", true);
        boolean isTotpConfigured = false;
        if (user != null) {
            isTotpConfigured = this.session.userCredentialManager().isConfiguredFor(this.realm, user, this.realm.getOTPPolicy().getType());
        }
        map.put("isTotpConfigured", isTotpConfigured);
        FreeMarkerUtil freeMarkerUtil = new FreeMarkerUtil();
        String result = freeMarkerUtil.processTemplate(map, "index.ftl", this.theme);
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK).type("text/html; charset=utf-8").language(Locale.ENGLISH).entity((Object)result);
        return builder.build();
    }

    private Map<String, String> supportedLocales(Properties messages) throws IOException {
        HashMap<String, String> supportedLocales = new HashMap<String, String>();
        for (String l : this.realm.getSupportedLocales()) {
            String label = messages.getProperty("locale_" + l, l);
            supportedLocales.put(l, label);
        }
        return supportedLocales;
    }

    private String messagesToJsonString(Properties props) {
        if (props == null) {
            return "";
        }
        JsonObjectBuilder json = Json.createObjectBuilder();
        for (String prop : props.stringPropertyNames()) {
            json.add(prop, this.convertPropValue(props.getProperty(prop)));
        }
        return json.build().toString();
    }

    private String convertPropValue(String propertyValue) {
        propertyValue = propertyValue.replace("''", "%27");
        propertyValue = propertyValue.replace("'", "%27");
        propertyValue = propertyValue.replace("\"", "%22");
        propertyValue = this.putJavaParamsInNgTranslateFormat(propertyValue);
        return propertyValue;
    }

    private String putJavaParamsInNgTranslateFormat(String propertyValue) {
        Matcher matcher = this.bundleParamPattern.matcher(propertyValue);
        while (matcher.find()) {
            propertyValue = propertyValue.replace(matcher.group(1), "{{param_" + matcher.group(2) + "}}");
        }
        return propertyValue;
    }

    @GET
    @Path(value="index.html")
    public Response getIndexHtmlRedirect() {
        return Response.status((int)302).location(this.session.getContext().getUri().getRequestUriBuilder().path("../").build(new Object[0])).build();
    }

    private String[] getReferrer() {
        String referrer = (String)this.session.getContext().getUri().getQueryParameters().getFirst((Object)"referrer");
        if (referrer == null) {
            return null;
        }
        String referrerUri = (String)this.session.getContext().getUri().getQueryParameters().getFirst((Object)"referrer_uri");
        ClientModel referrerClient = this.realm.getClientByClientId(referrer);
        if (referrerClient != null) {
            if ((referrerUri = referrerUri != null ? RedirectUtils.verifyRedirectUri(this.session, referrerUri, referrerClient) : ResolveRelative.resolveRelativeUri(this.session, this.client.getRootUrl(), referrerClient.getBaseUrl())) != null) {
                String referrerName = referrerClient.getName();
                if (Validation.isBlank(referrerName)) {
                    referrerName = referrer;
                }
                return new String[]{referrer, referrerName, referrerUri};
            }
        } else if (referrerUri != null) {
            referrerClient = this.realm.getClientByClientId(referrer);
            if (this.client != null && (referrerUri = RedirectUtils.verifyRedirectUri(this.session, referrerUri, referrerClient)) != null) {
                return new String[]{referrer, referrer, referrerUri};
            }
        }
        return null;
    }
}

