/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.url;

import javax.ws.rs.core.UriInfo;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.urls.HostnameProvider;

@Deprecated
public class FixedHostnameProvider
implements HostnameProvider {
    private final KeycloakSession session;
    private final String globalHostname;
    private final boolean alwaysHttps;
    private final int httpPort;
    private final int httpsPort;

    public FixedHostnameProvider(KeycloakSession session, boolean alwaysHttps, String globalHostname, int httpPort, int httpsPort) {
        this.session = session;
        this.alwaysHttps = alwaysHttps;
        this.globalHostname = globalHostname;
        this.httpPort = httpPort;
        this.httpsPort = httpsPort;
    }

    public String getScheme(UriInfo originalUriInfo) {
        return this.alwaysHttps ? "https" : originalUriInfo.getRequestUri().getScheme();
    }

    public String getHostname(UriInfo originalUriInfo) {
        String realmHostname;
        RealmModel realm = this.session.getContext().getRealm();
        if (realm != null && (realmHostname = this.session.getContext().getRealm().getAttribute("hostname")) != null && !realmHostname.isEmpty()) {
            return realmHostname;
        }
        return this.globalHostname;
    }

    public int getPort(UriInfo originalUriInfo) {
        boolean https = originalUriInfo.getRequestUri().getScheme().equals("https");
        if (https) {
            if (this.httpsPort == -1) {
                return originalUriInfo.getRequestUri().getPort();
            }
            if (this.httpsPort == 443) {
                return -1;
            }
            return this.httpsPort;
        }
        if (this.alwaysHttps) {
            if (this.httpsPort == 443) {
                return -1;
            }
            return this.httpsPort;
        }
        if (this.httpPort == -1) {
            return originalUriInfo.getRequestUri().getPort();
        }
        if (this.httpPort == 80) {
            return -1;
        }
        return this.httpPort;
    }
}

